<?php 
include 'koneksi.php'; 

 $batas = 5; 
 $halaman = isset($_GET['halaman']) ? (int)$_GET['halaman'] : 1;
 $halaman_awal = ($halaman > 1) ? ($halaman * $batas) - $batas : 0;
 $kata_kunci = isset($_GET['cari']) ? mysqli_real_escape_string($koneksi, $_GET['cari']) : "";

if (!empty($kata_kunci)) {
    $query = "SELECT * FROM laporan WHERE nim LIKE '%$kata_kunci%' OR nama LIKE '%$kata_kunci%' OR masalah LIKE '%$kata_kunci%' ORDER BY id DESC LIMIT $halaman_awal, $batas";
    $query_count = "SELECT * FROM laporan WHERE nim LIKE '%$kata_kunci%' OR nama LIKE '%$kata_kunci%' OR masalah LIKE '%$kata_kunci%'";
} else {
    $query = "SELECT * FROM laporan ORDER BY id DESC LIMIT $halaman_awal, $batas";
    $query_count = "SELECT * FROM laporan";
}
 $result = mysqli_query($koneksi, $query);
 $jumlah_data = mysqli_num_rows(mysqli_query($koneksi, $query_count));
 $total_halaman = ceil($jumlah_data / $batas);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Laporan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold">📋 Daftar Laporan Masalah</h2>
        <a href="input.php" class="btn btn-primary btn-lg">+ Buat Laporan</a>
    </div>

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form action="" method="GET" class="row g-3">
                <div class="col-md-10">
                    <input type="text" name="cari" class="form-control" placeholder="Cari NIM, Nama, atau Masalah..." value="<?= isset($_GET['cari']) ? $_GET['cari'] : ''; ?>">
                </div>
                <div class="col-md-2 d-grid gap-2">
                    <button type="submit" class="btn btn-primary">🔍 Cari</button>
                    <a href="index.php" class="btn btn-outline-secondary">🔄 Clear</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body table-responsive p-0">
            <table class="table table-striped table-hover mb-0 align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Waktu</th><th>Mahasiswa</th><th>Permasalahan</th><th>Penanganan & Catatan</th><th>Status</th><th>Log Waktu</th><th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($result) > 0) { while ($row = mysqli_fetch_assoc($result)) { 
                        $badge = ($row['status_selesai'] == 'Selesai') ? 'bg-success' : 'bg-warning text-dark'; ?>
                    <tr>
                        <td><b><?= $row['hari']; ?></b><br><?= $row['tanggal']; ?> <?= $row['jam']; ?></td>
                        <td><b><?= $row['nama']; ?></b><br><small><?= $row['nim']; ?> - <?= $row['prodi']; ?></small></td>
                        <td><?= nl2br($row['masalah']); ?></td>
                        <td><b>Pen:</b> <?= nl2br($row['penanganan']); ?><hr><b>Cat:</b> <?= nl2br($row['catatan']); ?></td>
                        <td><span class="badge <?= $badge; ?>"><?= $row['status_selesai']; ?></span></td>
                        <td class="small"><?= $row['created_at']; ?></td>
                        <td>
                            <a href="update_laporan.php?token=<?= base64_encode($row['id']); ?>" class="btn btn-warning btn-sm">Edit</a>
                            <a href="hapus.php?id=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus?')">Hapus</a>
                        </td>
                    </tr>
                    <?php } } else { echo "<tr><td colspan='7' class='text-center'>Tidak ada data.</td></tr>"; } ?>
                </tbody>
            </table>
        </div>
        <?php if ($jumlah_data > 0) { ?>
        <div class="card-footer bg-white py-3">
            <nav><ul class="pagination justify-content-center mb-0">
                <li class="page-item <?= ($halaman <= 1) ? 'disabled' : ''; ?>"><a class="page-link" href="?halaman=<?= $halaman - 1; ?>&cari=<?= $kata_kunci; ?>">« Prev</a></li>
                <?php for($x=1; $x<=$total_halaman; $x++){ ?> <li class="page-item <?= ($halaman == $x) ? 'active' : ''; ?>"><a class="page-link" href="?halaman=<?= $x; ?>&cari=<?= $kata_kunci; ?>"><?= $x; ?></a></li> <?php } ?>
                <li class="page-item <?= ($halaman >= $total_halaman) ? 'disabled' : ''; ?>"><a class="page-link" href="?halaman=<?= $halaman + 1; ?>&cari=<?= $kata_kunci; ?>">Next »</a></li>
            </ul></nav>
        </div>
        <?php } ?>
    </div>
</div>
</body>
</html>