/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":1074,"face":{"font-family":"Trebuchet MS","font-weight":400,"font-stretch":"normal","units-per-em":"2048","panose-1":"2 11 6 3 2 2 2 2 2 4","ascent":"1638","descent":"-410","x-height":"20","bbox":"-8 -1642 1732 428","underline-thickness":"127","underline-position":"-198","unicode-range":"U+0020-U+007E"},"glyphs":{" ":{"w":617,"k":{"Y":37,"T":37,"A":113}},"!":{"d":"413,-382r-71,0v-84,-543,-80,-645,-77,-1109r226,0v2,463,8,561,-78,1109xm234,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},"\"":{"d":"229,-1086r-133,0r-24,-381r184,0xm559,-1086r-133,0r-24,-381r184,0","w":665},"#":{"d":"879,-947r-99,393r161,0r0,128r-194,0r-124,446r-127,0r124,-446r-297,0r-124,446r-130,0r123,-446r-155,0r0,-128r188,0r99,-393r-172,0r0,-128r205,0r102,-412r131,0r-103,412r297,0r103,-412r127,0r-103,412r175,0r0,128r-207,0xm455,-947r-99,393r297,0r99,-393r-297,0"},"$":{"d":"961,-355v0,205,-165,342,-364,370r0,231r-139,0r0,-221v-79,-2,-272,-59,-318,-92r72,-184v58,44,194,96,290,96v187,0,316,-161,238,-337v-45,-102,-83,-101,-217,-166v-119,-57,-275,-128,-327,-221v-37,-66,-60,-141,-60,-231v0,-197,143,-344,322,-372r0,-160r139,0r0,153v143,6,240,32,291,78r-59,174v-49,-37,-186,-83,-274,-83v-168,0,-265,154,-198,309v46,109,180,145,304,207v186,93,300,198,300,449"},"%":{"d":"218,20r-127,0r883,-1511r126,0xm618,-1143v0,191,-104,339,-279,339v-185,0,-278,-119,-278,-358v0,-183,114,-331,287,-329v181,2,270,147,270,348xm345,-1389v-110,0,-158,111,-158,237v0,129,39,246,143,246v108,0,162,-82,162,-245v0,-159,-49,-238,-147,-238xm1158,-319v0,191,-104,339,-279,339v-185,0,-278,-119,-278,-358v0,-183,114,-331,287,-329v181,2,270,147,270,348xm885,-565v-110,0,-158,111,-158,237v0,129,39,246,143,246v108,0,162,-82,162,-245v0,-159,-49,-238,-147,-238","w":1229},"&":{"d":"1030,-388v3,163,22,238,165,238v36,0,78,-12,127,-37r27,177v-70,20,-150,30,-240,30v-62,0,-122,-24,-180,-71v-97,47,-213,71,-350,71v-284,1,-441,-182,-437,-473v2,-188,54,-268,161,-377v-94,-93,-141,-190,-141,-291v1,-216,188,-370,425,-370v137,0,243,30,318,91r-83,154v-76,-63,-144,-95,-204,-95v-177,0,-266,80,-266,240v0,87,39,160,116,220r372,0r0,-183r190,-73r0,259r249,0r0,160r-249,0r0,330xm851,-199v-24,-148,-5,-351,-11,-519r-403,0v-63,81,-95,167,-95,256v0,208,102,312,305,312v91,0,159,-16,204,-49","w":1446},"'":{"d":"229,-1086r-133,0r-24,-381r184,0","w":327},"(":{"d":"618,428v-261,-176,-425,-556,-425,-987v0,-340,201,-811,425,-916r0,83v-132,191,-198,469,-198,835v0,435,66,728,198,880r0,105","w":752},")":{"d":"193,-1475v224,105,425,576,425,916v0,431,-164,811,-425,987r0,-105v132,-152,198,-445,198,-880v0,-366,-66,-644,-198,-835r0,-83","w":752},"*":{"d":"597,-1127r-173,3r158,105r47,62r-122,104r-54,-70r-82,-159r-91,162r-43,64r-131,-101r50,-69r158,-83r-176,-27r-90,-32r72,-150r96,37r125,95r-63,-205r0,-79r176,0r0,76r-60,211r158,-107r74,-27r57,161","w":752},"+":{"d":"611,-706r349,0r0,141r-349,0r0,345r-141,0r0,-345r-348,0r0,-141r348,0r0,-343r141,0r0,343"},",":{"d":"373,-277v74,0,146,82,142,160v-14,257,-101,330,-291,480r-51,-72v115,-94,172,-174,172,-240v0,-29,-10,-59,-30,-88v-57,-27,-86,-67,-86,-118v-1,-73,67,-122,144,-122","w":752},"-":{"d":"159,-506r0,-175r428,0r0,175r-428,0","w":752},"\u2010":{"d":"159,-506r0,-175r428,0r0,175r-428,0","w":752},".":{"d":"204,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},"\/":{"d":"350,0r-161,0r531,-1471r159,0"},"0":{"d":"64,-777v0,-211,43,-382,128,-515v85,-133,205,-199,360,-199v153,0,269,55,346,166v77,111,115,304,115,580v0,237,-40,425,-121,561v-81,136,-199,204,-354,204v-155,0,-274,-55,-354,-165v-80,-110,-120,-321,-120,-632xm264,-759v0,406,87,609,260,609v99,0,172,-45,219,-135v47,-90,70,-248,70,-473v0,-155,-9,-269,-27,-342v-32,-128,-97,-221,-239,-221v-189,0,-283,187,-283,562"},"1":{"d":"200,-1124v141,-69,348,-229,438,-347r60,0r0,1471r-200,0r0,-1123r-298,186r0,-187"},"2":{"d":"433,-1491v263,0,449,123,449,373v0,110,-53,249,-158,416r-329,522r574,0r0,180r-900,0r0,-40r459,-703v96,-147,144,-272,144,-375v0,-135,-76,-203,-229,-203v-113,-1,-218,70,-255,150r-129,-106v45,-132,192,-214,374,-214"},"3":{"d":"941,-406v0,283,-197,426,-491,426v-131,0,-273,-60,-341,-124r96,-154v65,72,148,108,248,108v185,0,278,-91,278,-272v0,-172,-128,-288,-312,-279r0,-162v174,3,264,-72,263,-224v0,-156,-80,-234,-239,-234v-87,0,-156,29,-207,87r-89,-136v62,-81,166,-121,311,-121v237,0,434,142,434,365v0,160,-109,303,-226,342v156,49,275,181,275,378"},"4":{"d":"882,-399r0,399r-190,0r0,-399r-667,0r0,-114r787,-958r70,0r0,918r148,0r0,154r-148,0xm692,-1072r-430,519r430,0r0,-519"},"5":{"d":"542,-1000v280,0,419,181,419,469v0,367,-164,551,-491,551v-137,0,-250,-38,-340,-114r77,-167v91,74,178,111,262,111v188,0,282,-117,282,-352v0,-219,-93,-328,-278,-328v-89,0,-170,38,-241,115r-68,-47r0,-709r729,0r0,170r-539,0r0,356v49,-37,112,-55,188,-55"},"6":{"d":"989,-452v0,268,-171,477,-423,477v-321,0,-482,-213,-482,-639v0,-334,321,-826,588,-877r97,107v-99,25,-436,426,-439,547v55,-53,132,-80,231,-80v265,-1,428,189,428,465xm784,-442v0,-167,-85,-305,-236,-305v-169,0,-254,96,-254,289v0,209,86,313,257,313v153,0,233,-134,233,-297"},"7":{"d":"428,0r-222,0v104,-333,408,-980,569,-1281r-691,0r0,-190r950,0r0,78r-129,254r-136,283r-139,314v-45,107,-85,206,-119,297v-34,91,-62,173,-83,245"},"8":{"d":"89,-406v0,-175,131,-358,264,-409v-107,-55,-208,-178,-211,-323v-3,-220,172,-353,396,-353v239,0,397,127,397,354v0,138,-113,292,-209,342v176,99,264,228,264,389v0,273,-180,426,-457,426v-296,0,-444,-142,-444,-426xm734,-1142v0,-110,-84,-179,-196,-179v-131,0,-196,60,-196,181v0,89,85,177,256,263v91,-85,136,-174,136,-265xm533,-150v146,0,257,-110,257,-256v0,-54,-17,-104,-50,-152v-33,-48,-110,-105,-231,-170v-147,79,-220,187,-220,322v0,142,102,256,244,256"},"9":{"d":"74,-1014v0,-268,171,-477,423,-477v321,0,482,213,482,639v0,334,-321,826,-588,877r-97,-107v97,-25,438,-425,439,-546v-55,53,-132,79,-231,79v-265,1,-428,-189,-428,-465xm279,-1024v0,167,85,305,236,305v169,0,254,-96,254,-289v0,-209,-86,-313,-257,-313v-153,0,-233,134,-233,297"},":":{"d":"204,-941v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151xm204,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},";":{"d":"204,-941v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151xm373,-277v74,0,146,82,142,160v-14,257,-101,330,-291,480r-51,-72v115,-94,172,-174,172,-240v0,-29,-10,-59,-30,-88v-57,-27,-86,-67,-86,-118v-1,-73,67,-122,144,-122","w":752},"<":{"d":"889,-218r-739,-358r0,-123r739,-354r0,161r-571,255r571,258r0,161"},"=":{"d":"960,-876r0,141r-838,0r0,-141r838,0xm960,-536r0,141r-838,0r0,-141r838,0"},">":{"d":"889,-576r-739,358r0,-161r571,-258r-571,-255r0,-161r739,354r0,123"},"?":{"d":"341,-1491v192,0,353,122,349,312v-2,112,-43,196,-104,261r-146,156v-75,104,-109,188,-74,333r-132,0v-46,-123,-39,-168,-8,-284v24,-88,209,-269,246,-340v20,-38,32,-74,32,-109v0,-117,-71,-176,-213,-176v-68,0,-127,24,-178,73r-73,-143v67,-55,168,-83,301,-83xm174,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},"@":{"d":"242,-581v0,346,221,593,563,593v154,0,278,-43,371,-128v31,11,76,31,135,58v-128,128,-297,192,-506,192v-421,0,-705,-294,-705,-715v0,-422,287,-744,705,-744v398,0,673,266,673,664v0,210,-123,407,-326,407v-106,0,-183,-23,-230,-70v-57,52,-124,78,-201,78v-137,0,-241,-82,-239,-216v3,-190,187,-259,400,-258v-10,-98,-49,-147,-118,-147v-70,0,-125,19,-166,56r-48,-99v55,-41,121,-61,200,-61v185,0,278,106,278,319r0,239v170,128,308,18,308,-251v0,-301,-229,-539,-531,-539v-340,0,-563,275,-563,622xm636,-467v0,72,60,126,133,124v42,0,80,-17,113,-50r0,-234v-148,-9,-246,35,-246,160","w":1578},"A":{"d":"982,0r-101,-309r-545,0r-108,309r-224,0r595,-1485r53,0r552,1485r-222,0xm616,-1101r-227,645r435,0","w":1208,"k":{"y":84,"w":94,"v":113,"Y":218,"W":180,"V":180,"T":199," ":113}},"B":{"d":"1079,-423v3,269,-229,423,-511,423r-418,0r0,-1465v178,-9,306,-13,385,-13v267,-2,451,112,455,361v2,137,-131,269,-244,291v214,53,330,157,333,403xm350,-1305r0,421v42,4,94,6,156,6v189,0,284,-77,284,-231v0,-135,-87,-203,-261,-203v-67,0,-126,2,-179,7xm869,-455v-5,-213,-123,-278,-358,-279r-161,5r0,559v289,34,525,-6,519,-285","w":1159},"C":{"d":"80,-728v0,-405,245,-762,631,-762v159,0,284,26,374,79r-67,171v-64,-47,-165,-70,-302,-70v-281,0,-426,285,-426,594v0,300,155,561,428,561v137,0,243,-49,317,-146r110,153v-116,115,-265,173,-448,173v-401,2,-617,-333,-617,-753","w":1225},"D":{"d":"511,-1475v406,-5,665,277,665,683v0,528,-244,792,-731,792r-295,0r0,-1465v188,-7,308,-10,361,-10xm516,-180v306,-4,450,-259,450,-595v0,-347,-156,-520,-467,-520v-19,0,-68,3,-149,10r0,1095v45,7,100,10,166,10","w":1256},"E":{"d":"350,-1285r0,407r484,0r0,170r-484,0r0,528r664,0r0,180r-864,0r0,-1465r875,0r0,180r-675,0","w":1097},"F":{"d":"350,-1285r0,407r515,0r0,170r-515,0r0,708r-200,0r0,-1465r905,0r0,180r-705,0","w":1075,"k":{"A":217,".":369,",":369}},"G":{"d":"80,-727v0,-440,275,-763,712,-763v153,0,277,42,373,127r-83,165v-101,-75,-199,-112,-296,-112v-319,-2,-496,258,-496,591v0,320,177,566,486,564v107,0,193,-32,259,-96r0,-343r-203,0r0,-170r403,0r0,638v-96,87,-321,151,-501,151v-416,0,-654,-322,-654,-752","w":1385},"H":{"d":"990,0r0,-708r-640,0r0,708r-200,0r0,-1465r200,0r0,587r640,0r0,-587r200,0r0,1465r-200,0","w":1340},"I":{"d":"185,0r0,-1465r200,0r0,1465r-200,0","w":570},"J":{"d":"826,-547v-6,377,-84,562,-442,567v-192,3,-327,-129,-335,-313r175,0v16,89,69,133,159,133v89,0,153,-20,189,-58v36,-38,54,-145,54,-321r0,-926r200,0r0,918","w":976},"K":{"d":"958,0r-413,-674r-195,277r0,397r-200,0r0,-1465r200,0r0,797r544,-797r223,0r-438,635r500,830r-221,0","w":1179,"k":{"w":64,"u":64,"o":64,"n":64,"i":64,"e":64}},"L":{"d":"150,0r0,-1465r200,0r0,1285r662,0r0,180r-862,0","w":1037,"k":{"y":170,"Y":265,"W":256,"V":284,"T":209," ":76}},"M":{"d":"1253,0r-174,-941r-320,961r-50,0r-329,-961r-170,941r-190,0r274,-1465r91,0r349,1069r322,-1069r90,0r297,1465r-190,0","w":1453},"N":{"d":"1097,20r-757,-1071r0,1051r-190,0r0,-1465r80,0r737,1013r0,-1013r190,0r0,1485r-60,0","w":1307},"O":{"d":"670,25v-391,1,-590,-358,-590,-770v0,-392,213,-746,590,-746v425,0,630,303,630,746v0,450,-202,768,-630,770xm670,-155v303,0,420,-257,420,-590v0,-377,-140,-566,-420,-566v-124,0,-217,52,-283,152v-129,194,-125,633,3,835v70,110,159,169,280,169","w":1380},"P":{"d":"350,-564r0,564r-200,0r0,-1465v151,-7,243,-10,274,-10v425,0,638,142,638,427v0,329,-188,494,-564,494v-23,0,-72,-3,-148,-10xm350,-1285r0,541v85,7,129,10,134,10v248,0,372,-98,372,-293v0,-179,-132,-268,-397,-268v-27,0,-63,3,-109,10","w":1142,"k":{"r":96,"o":96,"i":96,"h":96,"e":96,"a":96,"A":228,".":400,",":400," ":37}},"Q":{"d":"670,-1491v425,0,630,303,630,746v0,337,-101,568,-302,693v73,107,195,160,366,160r156,0r-30,195v-349,0,-578,-97,-687,-291v-469,91,-723,-301,-723,-757v0,-392,213,-746,590,-746xm670,-155v303,0,420,-259,420,-590v0,-377,-140,-566,-420,-566v-124,0,-217,52,-283,152v-129,194,-125,633,3,835v70,110,159,169,280,169","w":1384},"R":{"d":"1054,-1060v0,182,-138,356,-287,386r425,674r-229,0r-391,-629v-45,0,-115,-3,-212,-10r0,639r-200,0r0,-1465r366,-15v352,0,528,140,528,420xm844,-1064v0,-229,-238,-247,-484,-221r0,476v48,7,95,10,140,10v226,-3,344,-50,344,-265","w":1192,"k":{"u":59,"o":83,"e":83,"Y":131,"W":131,"V":94,"T":84}},"S":{"d":"904,-370v-2,238,-222,395,-487,395v-130,0,-241,-31,-333,-92r73,-184v61,47,190,94,289,96v146,3,266,-90,259,-227v-8,-164,-76,-198,-238,-276v-119,-57,-275,-128,-327,-221v-37,-66,-60,-141,-60,-231v0,-222,184,-380,414,-380v162,0,275,26,338,79r-59,174v-49,-37,-186,-83,-274,-83v-168,0,-270,157,-198,309v45,96,87,103,212,164v120,59,277,131,331,227v38,67,60,149,60,250","w":985},"T":{"d":"684,-1285r0,1285r-200,0r0,-1285r-466,0r0,-180r1153,0r0,180r-487,0","w":1189,"k":{"y":236,"w":283,"u":265,"s":246,"r":225,"o":255,"i":85,"e":255,"c":255,"a":255,"O":113,"A":199,";":227,":":227,".":340,"-":198,",":340," ":37}},"U":{"d":"662,25v-318,0,-513,-161,-512,-472r0,-1018r200,0r0,1003v-2,178,129,307,310,307v194,0,318,-120,318,-312r0,-998r200,0r0,1019v2,301,-209,471,-516,471","w":1328},"V":{"d":"660,20r-101,0r-546,-1485r222,0r377,1079r363,-1079r215,0","w":1203,"k":{"y":76,"u":133,"r":123,"o":132,"i":37,"e":132,"a":161,"A":209,";":123,":":123,".":300,"-":151,",":300}},"W":{"d":"1276,20r-63,0r-349,-1010r-326,1010r-63,0r-462,-1485r208,0r294,1023r322,-1023r70,0r318,1021r299,-1021r208,0","w":1745,"k":{"y":37,"u":84,"r":103,"o":94,"i":28,"e":94,"a":114,"A":180,";":37,":":37,".":189,"-":141,",":189}},"X":{"d":"915,0r-364,-588r-336,588r-202,0r432,-760r-397,-706r197,1r313,554r345,-554r201,0r-455,709r478,756r-212,0","w":1140},"Y":{"d":"685,-656r0,656r-200,0r0,-656r-472,-809r206,0r365,640r365,-640r206,0","w":1168,"k":{"v":122,"u":151,"q":245,"p":190,"o":235,"i":114,"e":215,"a":190,"A":218,";":179,":":179,".":330,"-":250,",":330," ":37}},"Z":{"d":"100,0r0,-50r630,-1235r-620,0r0,-180r895,0r0,50r-632,1235r654,0r0,180r-927,0","w":1127},"[":{"d":"202,420r0,-1930r463,0r0,170r-263,0r0,1590r263,0r0,170r-463,0","w":752},"\\":{"d":"512,0r-515,-1471r142,0r516,1471r-143,0","w":728},"]":{"d":"550,420r-463,0r0,-170r263,0r0,-1590r-263,0r0,-170r463,0r0,1930","w":752},"^":{"d":"763,-907r-244,-448r-248,452r-122,0r318,-568r107,0r316,564r-127,0"},"_":{"d":"-8,254r0,-129r1085,0r0,129r-1085,0"},"`":{"d":"559,-1285r-226,-333r197,0r169,333r-140,0"},"a":{"d":"996,19v-150,-1,-218,-35,-256,-142v-76,95,-192,143,-349,143v-167,0,-314,-146,-311,-319v4,-275,344,-458,642,-362v0,-173,-77,-260,-232,-260v-119,0,-210,32,-274,96r-80,-159v64,-55,215,-108,332,-107v312,2,444,132,444,443r0,384v0,94,28,157,84,188r0,95xm596,-546v-169,-6,-326,100,-326,249v0,111,66,167,197,167v96,0,181,-46,255,-137r0,-259v-60,-13,-102,-20,-126,-20","w":1076},"b":{"d":"558,20v-99,0,-214,-46,-261,-97r-67,97r-95,0r0,-1530r190,0r0,518v34,-49,160,-99,248,-99v294,0,493,239,493,536v0,338,-185,575,-508,575xm504,-931v-44,0,-163,57,-179,84r0,618v-2,22,149,97,179,89v272,-4,359,-122,362,-405v2,-233,-136,-386,-362,-386","w":1141},"c":{"d":"65,-525v0,-338,215,-566,555,-566v105,0,267,61,323,107r-94,134v-39,-39,-163,-82,-247,-81v-219,2,-337,173,-337,406v0,239,122,384,351,385v85,0,171,-33,258,-99r75,160v-102,66,-228,99,-379,99v-300,1,-505,-229,-505,-545","w":1014},"d":{"d":"75,-509v0,-294,212,-582,487,-582v111,0,195,26,252,78r0,-497r190,0r0,1509r-190,0r0,-79v-66,66,-162,99,-288,99v-280,1,-451,-231,-451,-528xm627,-140v56,0,172,-49,187,-89r0,-594v-48,-72,-114,-108,-197,-108v-210,-2,-342,185,-342,404v0,258,117,387,352,387","w":1141},"e":{"d":"567,-1091v328,-5,542,237,470,574r-772,0v-4,223,123,376,337,377v109,0,199,-32,272,-95r80,137v-75,71,-237,118,-389,118v-292,0,-500,-239,-500,-543v0,-310,210,-564,502,-568xm863,-655v1,-163,-120,-276,-287,-276v-165,0,-295,123,-306,276r593,0","w":1117},"f":{"d":"221,-1071v-5,-253,133,-438,368,-439v55,0,115,10,178,30r-53,140v-39,-13,-75,-20,-108,-20v-137,0,-224,137,-195,289r218,0r0,160r-218,0r0,911r-190,0r0,-911r-156,0r0,-160r156,0","w":757},"g":{"d":"968,90v0,287,-396,394,-687,293v-76,-26,-138,-55,-185,-90r103,-152v111,74,213,111,306,111v139,0,278,-45,278,-155v0,-87,-63,-130,-188,-130v-42,0,-200,32,-247,32v-152,0,-228,-57,-228,-172v0,-86,102,-139,186,-158v-151,-71,-226,-193,-226,-368v0,-221,184,-392,406,-392v105,0,188,22,247,65r95,-114r124,117r-114,86v105,136,95,397,-28,520v-70,70,-156,113,-265,126v-86,10,-158,6,-232,37v-31,13,-47,29,-47,49v0,27,33,41,98,41v50,0,219,-31,269,-31v198,0,335,97,335,285xm714,-698v0,-126,-92,-240,-215,-240v-130,0,-224,111,-224,240v0,142,84,259,224,259v140,0,215,-114,215,-259","w":1028},"h":{"d":"622,-1091v235,0,363,174,363,418r0,673r-190,0r0,-673v1,-152,-78,-259,-225,-258v-99,0,-204,72,-245,135r0,796r-190,0r0,-1510r190,0r0,557v45,-75,177,-138,297,-138","w":1119},"i":{"d":"214,-1359v0,-64,53,-117,117,-117v63,0,118,54,118,117v0,64,-54,118,-118,118v-63,0,-117,-55,-117,-118xm227,0r0,-911r-147,0r0,-160r337,0r0,1071r-190,0","w":584},"j":{"d":"311,-1359v0,-64,53,-117,117,-117v63,0,118,54,118,117v0,64,-54,118,-118,118v-64,0,-117,-54,-117,-118xm18,250v236,-3,341,-45,341,-255r0,-906r-213,0r0,-160r403,0r0,1062v-4,318,-193,428,-531,429r0,-170","w":751},"k":{"d":"827,0r-336,-536r-166,171r0,365r-190,0r0,-1510r190,0r0,937r410,-498r222,0r-343,407r419,664r-206,0","w":1033},"l":{"d":"340,-335v-2,111,71,186,179,185r0,170v-246,0,-369,-108,-369,-323r0,-1207r190,0r0,1175","w":604},"m":{"d":"1217,-1091v225,0,348,145,348,375r0,716r-190,0r0,-678v0,-169,-73,-253,-219,-253v-92,0,-186,72,-211,139r0,792r-190,0r0,-761v0,-112,-98,-170,-217,-170v-82,0,-186,81,-213,141r0,790r-190,0r0,-1071r124,0r63,124v73,-96,165,-144,275,-144v153,0,261,48,322,143v38,-79,179,-143,298,-143","w":1700},"n":{"d":"570,-931v-97,0,-205,70,-245,135r0,796r-190,0r0,-1071r130,0r60,138v63,-105,165,-158,307,-158v235,0,352,143,352,428r0,663r-190,0r0,-623v-3,-206,-39,-308,-224,-308","w":1119},"o":{"d":"550,20v-315,0,-485,-234,-485,-558v0,-312,186,-553,485,-553v317,0,484,224,484,553v0,326,-173,558,-484,558xm550,-936v-194,0,-285,180,-285,398v0,269,95,403,285,403v197,0,284,-183,284,-403v0,-265,-95,-398,-284,-398","w":1099},"p":{"d":"570,20v-78,0,-216,-36,-245,-79r0,479r-190,0r0,-1491r190,0r0,88v72,-72,159,-108,261,-108v322,2,482,216,482,558v0,319,-176,553,-498,553xm515,-931v-62,0,-157,54,-190,91r0,624v23,37,124,76,189,76v236,0,354,-133,354,-400v0,-263,-97,-391,-353,-391","w":1141},"q":{"d":"75,-533v0,-324,201,-559,509,-558v93,0,180,34,261,101r51,-81r115,0r0,1491r-190,0r0,-483v-55,55,-148,83,-278,83v-307,0,-468,-229,-468,-553xm275,-533v0,231,117,392,333,393v91,0,162,-23,213,-70r0,-639v-55,-55,-123,-82,-205,-82v-221,-2,-341,171,-341,398","w":1141},"r":{"d":"717,-888v-185,-134,-377,70,-377,274r0,614r-190,0r0,-1071r190,0r0,171v99,-171,233,-223,456,-173","w":796,"k":{".":273,",":292}},"s":{"d":"764,-287v-1,205,-161,307,-381,307v-113,0,-219,-28,-318,-84r67,-180v106,69,191,104,256,104v117,0,176,-49,176,-148v0,-71,-57,-130,-170,-182v-141,-66,-181,-78,-256,-162v-41,-46,-65,-101,-66,-179v-1,-184,155,-282,347,-280v78,0,176,25,295,74r-54,176v-75,-60,-151,-90,-227,-90v-80,0,-160,41,-161,113v0,69,40,119,117,156v172,81,377,137,375,375","w":829},"t":{"d":"505,20v-172,0,-302,-153,-302,-333r0,-608r-124,0r0,-150r124,0r0,-224r190,-73r0,297r294,0r0,150r-294,0r0,532v1,165,41,249,192,249v49,0,99,-12,151,-37r28,167v-79,20,-165,30,-259,30","w":812},"u":{"d":"488,20v-238,0,-363,-146,-363,-388r0,-703r190,0r0,683v0,165,72,248,215,248v123,0,245,-88,275,-179r0,-752r190,0r0,1071r-190,0r0,-148v-36,79,-199,168,-317,168","w":1119},"v":{"d":"521,20r-50,0r-459,-1094r208,0r283,750r289,-750r199,0","w":1003,"k":{".":275,",":275}},"w":{"d":"1125,20r-50,0r-314,-729r-313,729r-50,0r-383,-1094r203,0r229,703r285,-703r50,0r294,703r246,-703r187,0","w":1524,"k":{".":217,",":217}},"x":{"d":"787,0r-292,-390r-261,390r-222,0r389,-548r-357,-523r214,0r240,368r269,-368r210,0r-389,523r426,548r-227,0","w":1026},"y":{"d":"124,250v136,4,289,-72,289,-191v0,-149,-66,-269,-111,-385r-290,-745r194,0r315,828r283,-828r194,0r-454,1253v-46,135,-234,241,-420,238r0,-170","w":1010,"k":{".":250,",":250}},"z":{"d":"338,-170r594,0r0,170r-892,0r0,-50r609,-851r-599,0r0,-170r876,0r0,54","w":972},"{":{"d":"431,-317v6,83,-63,283,-63,369v0,152,88,228,263,228r76,0r0,140r-139,0v-206,4,-391,-107,-395,-298v-2,-83,74,-348,74,-433v0,-132,-70,-203,-209,-212r0,-84v127,-8,209,-96,209,-229v0,-77,-74,-306,-74,-380v0,-182,191,-290,386,-286r148,0r0,133r-175,0v-109,0,-164,61,-164,184v0,78,63,254,63,330v0,105,-75,201,-225,288v111,44,216,128,225,250","w":752},"|":{"d":"462,276r0,-1681r146,0r0,1681r-146,0"},"}":{"d":"572,122v0,191,-190,302,-395,298r-139,0r0,-140r76,0v175,0,263,-76,263,-228v0,-87,-68,-286,-63,-369v8,-121,115,-207,225,-250v-150,-87,-225,-183,-225,-288v0,-76,63,-252,63,-330v0,-123,-55,-184,-164,-184r-175,0r0,-133r148,0v196,-4,386,104,386,286v0,74,-74,303,-74,380v0,133,82,221,209,229r0,84v-139,9,-209,80,-209,212v0,87,74,346,74,433","w":752},"~":{"d":"342,-716v91,-5,292,78,366,77v54,0,90,-26,108,-77r88,0v-35,138,-99,207,-192,207v-71,0,-305,-76,-355,-77v-47,0,-83,26,-108,77r-91,0v15,-97,82,-201,184,-207"},"\u00a0":{"w":617,"k":{"Y":37,"T":37,"A":113}}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":1200,"face":{"font-family":"Trebuchet MS","font-weight":700,"font-stretch":"normal","units-per-em":"2048","panose-1":"2 11 7 3 2 2 2 2 2 4","ascent":"1638","descent":"-410","x-height":"20","bbox":"-12 -1656 1805 455","underline-thickness":"200","underline-position":"-161","unicode-range":"U+0020-U+007E"},"glyphs":{" ":{"w":617,"k":{"Y":37,"T":37,"A":113}},"!":{"d":"426,-382r-104,0v-85,-539,-81,-645,-78,-1109r260,0v2,460,8,572,-78,1109xm218,-144v0,-88,76,-164,164,-164v88,0,163,76,163,164v0,88,-75,164,-163,164v-88,0,-164,-76,-164,-164","w":752},"\"":{"d":"667,-1036r-189,0r-28,-431r248,0xm287,-1036r-189,0r-28,-431r248,0","w":751},"#":{"d":"1174,-910r-215,0r-84,320r154,0r0,181r-202,0r-120,429r-195,0r118,-429r-230,0r-118,429r-195,0r118,-429r-140,0r0,-181r189,0r83,-320r-157,0r0,-181r205,0r108,-396r193,0r-105,396r229,0r108,-396r193,0r-104,396r167,0r0,181xm769,-910r-237,0r-84,320r235,0"},"$":{"d":"1042,-383v0,209,-152,346,-340,388r0,230r-229,0r0,-212v-116,-8,-222,-43,-318,-104r96,-233v103,72,204,108,303,108v153,0,229,-53,229,-158v0,-53,-24,-99,-59,-148v-59,-83,-375,-220,-444,-288v-70,-70,-122,-164,-122,-296v0,-197,142,-341,315,-379r0,-181r229,0r-1,171v123,12,214,42,274,90r-79,224v-91,-65,-188,-98,-289,-98v-112,0,-189,67,-189,171v0,84,94,170,279,262v166,83,245,131,311,274v24,53,34,113,34,179"},"%":{"d":"648,-1127v0,200,-119,355,-309,354v-205,0,-308,-124,-308,-373v0,-193,129,-347,317,-345v195,2,300,153,300,364xm217,-1136v0,108,30,208,113,208v88,0,132,-69,132,-207v0,-133,-39,-200,-117,-200v-85,0,-128,66,-128,199xm335,20r-196,0r918,-1511r195,0xm1348,-335v0,200,-119,356,-309,355v-205,0,-308,-124,-308,-373v0,-193,129,-347,317,-345v195,2,300,153,300,363xm917,-344v-1,108,28,208,113,208v88,0,132,-69,132,-207v0,-133,-39,-200,-117,-200v-85,0,-128,66,-128,199","w":1401},"&":{"d":"1060,-401v2,135,19,200,135,200v46,0,92,-10,138,-31r0,219v-140,40,-298,59,-408,-31v-100,43,-215,64,-346,64v-298,0,-469,-186,-467,-484v0,-141,50,-262,149,-362v-86,-87,-129,-181,-129,-280v1,-226,206,-385,455,-385v144,0,263,36,356,109r-106,182v-83,-59,-156,-89,-219,-89v-140,-2,-235,71,-236,202v0,71,32,132,96,183r332,0r0,-167r250,-93r0,263r249,0r0,211r-249,0r0,289xm817,-233v-15,-134,-4,-309,-7,-457r-358,0v-53,65,-80,137,-80,218v0,181,92,271,275,271v73,0,129,-11,170,-32","w":1446},"'":{"d":"337,-1036r-189,0r-28,-431r248,0","w":470},"(":{"d":"648,455v-294,-194,-481,-550,-485,-1013v-3,-369,227,-822,485,-936r0,138v-132,185,-198,451,-198,800v0,415,66,695,198,842r0,169","w":752},")":{"d":"163,-1494v258,115,488,567,485,936v-3,462,-192,820,-485,1013r0,-169v132,-147,198,-427,198,-842v0,-349,-66,-615,-198,-800r0,-138","w":752},"*":{"d":"671,-1102r-134,11r137,78r86,111r-193,144r-84,-122r-53,-128r-49,114r-111,136r-172,-154r118,-115r110,-57r-135,-12r-156,-62r98,-205r158,67r71,76r-54,-155r0,-136r236,1r0,131r-46,162r100,-89r142,-62r81,201","w":885},"+":{"d":"713,-535r0,355r-201,0r0,-355r-348,0r0,-201r348,0r0,-343r201,0r0,343r349,0r0,201r-349,0"},",":{"d":"373,-277v89,0,172,85,172,174v0,85,-19,161,-59,231v-40,70,-130,152,-269,246r-85,-109v122,-91,183,-163,183,-215v0,-20,-7,-40,-21,-59v-63,-31,-95,-74,-95,-129v-1,-84,84,-139,174,-139","w":752},"-":{"d":"109,-476r0,-235r529,0r0,235r-529,0","w":752},"\u2010":{"d":"109,-476r0,-235r529,0r0,235r-529,0","w":752},".":{"d":"354,50v-97,0,-180,-84,-180,-181v0,-97,83,-180,180,-180v97,0,180,83,180,180v0,97,-83,181,-180,181","w":752},"\/":{"d":"241,0r-225,0r553,-1471r223,0","w":799},"0":{"d":"75,-777v0,-364,193,-714,538,-714v341,0,511,249,511,746v0,233,-46,418,-138,557v-92,139,-221,208,-387,208v-179,0,-311,-64,-396,-192v-85,-128,-128,-330,-128,-605xm345,-759v0,195,19,339,57,431v38,92,101,138,189,138v95,0,158,-44,203,-124v71,-125,78,-724,2,-854v-43,-73,-101,-113,-188,-113v-175,0,-263,174,-263,522"},"1":{"d":"569,0r0,-1056r-298,179r0,-250v191,-93,343,-207,454,-344r104,0r0,1471r-260,0"},"2":{"d":"549,-1491v277,0,478,128,479,387v0,111,-54,250,-163,416r-300,457r550,0r0,231r-960,0r0,-76r464,-683v93,-137,139,-252,139,-345v0,-111,-66,-166,-199,-166v-101,0,-183,54,-245,161r-175,-138v62,-130,223,-244,410,-244"},"3":{"d":"1043,-419v0,292,-216,439,-521,439v-148,0,-274,-48,-379,-143r130,-201v77,82,161,123,252,123v165,0,248,-78,248,-233v0,-161,-129,-254,-312,-239r0,-214v164,8,263,-49,263,-187v0,-131,-70,-196,-209,-196v-72,0,-142,34,-210,102r-122,-179v57,-74,216,-144,347,-144v271,0,463,125,464,380v0,143,-61,251,-184,326v155,75,233,197,233,366"},"4":{"d":"984,-383r0,383r-250,0r0,-383r-667,0r0,-149r803,-939r114,0r0,882r148,0r0,206r-148,0xm734,-1029r-376,440r376,0r0,-440"},"5":{"d":"614,-1018v292,-1,449,182,449,479v0,373,-174,559,-521,559v-144,0,-270,-44,-377,-131r103,-214v106,83,197,124,273,124v168,0,252,-103,252,-310v0,-192,-61,-284,-248,-286v-81,0,-159,40,-236,119r-103,-67r0,-726r789,0r0,221r-539,0r0,262v44,-20,97,-30,158,-30"},"6":{"d":"1097,-463v0,275,-188,483,-453,483v-341,0,-512,-213,-512,-639v0,-179,66,-360,198,-543v132,-183,275,-293,430,-332r138,146v-176,89,-371,275,-439,456v326,-151,638,83,638,429xm832,-453v0,-146,-74,-265,-206,-265v-149,0,-224,83,-224,250v0,178,76,267,227,267v134,0,203,-107,203,-252"},"7":{"d":"537,0r-285,0v109,-335,295,-745,560,-1231r-671,0r0,-240r1010,0r0,111r-132,249r-137,275r-140,304v-45,103,-85,200,-120,290v-35,90,-63,170,-85,242"},"8":{"d":"117,-419v1,-167,116,-317,235,-383v-92,-59,-180,-185,-182,-321v-3,-230,190,-368,426,-368v251,0,425,131,427,369v1,124,-114,287,-201,328v109,44,256,231,256,375v0,283,-198,439,-487,439v-294,0,-476,-150,-474,-439xm762,-1126v1,-91,-72,-144,-166,-144v-111,0,-166,48,-166,145v0,94,115,198,190,223v64,-24,142,-142,142,-224xm591,-201v126,0,227,-76,227,-198v0,-101,-83,-201,-250,-298v-127,72,-191,165,-191,278v0,123,90,218,214,218"},"9":{"d":"116,-1003v0,-276,188,-488,453,-488v341,0,512,215,512,644v0,179,-65,360,-197,543v-132,183,-276,293,-431,332r-138,-146v203,-112,346,-258,430,-439v-45,20,-102,30,-171,30v-277,2,-458,-192,-458,-476xm584,-1270v-134,0,-203,112,-203,257v0,147,74,265,206,265v149,0,224,-83,224,-250v0,-181,-76,-272,-227,-272"},":":{"d":"354,-760v-97,0,-180,-84,-180,-181v0,-97,83,-180,180,-180v97,0,180,83,180,180v0,97,-83,181,-180,181xm354,50v-97,0,-180,-84,-180,-181v0,-97,83,-180,180,-180v97,0,180,83,180,180v0,97,-83,181,-180,181","w":752},";":{"d":"354,-760v-97,0,-180,-84,-180,-181v0,-97,83,-180,180,-180v97,0,180,83,180,180v0,97,-83,181,-180,181xm373,-277v89,0,172,85,172,174v0,85,-19,161,-59,231v-40,70,-130,152,-269,246r-85,-109v122,-91,183,-163,183,-215v0,-20,-7,-40,-21,-59v-63,-31,-95,-74,-95,-129v-1,-84,84,-139,174,-139","w":752},"<":{"d":"192,-557r0,-161r799,-383r0,228r-528,236r528,239r0,228"},"=":{"d":"179,-745r0,-201r898,0r0,201r-898,0xm179,-325r0,-201r898,0r0,201r-898,0"},">":{"d":"265,-170r0,-228r527,-239r-527,-236r0,-228r799,383r0,161"},"?":{"d":"821,-1162v0,330,-418,363,-324,718r-191,0v-4,-15,-36,-100,-35,-128v4,-93,32,-167,69,-230v31,-53,235,-251,235,-344v0,-93,-61,-140,-183,-140v-59,0,-121,30,-186,89r-103,-193v86,-67,199,-101,339,-101v205,0,379,127,379,329xm248,-144v0,-88,76,-164,164,-164v88,0,163,76,163,164v0,88,-75,164,-163,164v-88,0,-164,-76,-164,-164","w":897},"@":{"d":"1508,-658v0,220,-138,419,-356,419v-99,0,-175,-19,-230,-58v-57,44,-124,66,-201,66v-149,0,-269,-89,-269,-236v0,-168,132,-257,396,-266v-13,-63,-41,-94,-84,-94v-63,0,-127,19,-193,57r-59,-136v73,-53,153,-79,238,-79v205,0,308,112,308,335r0,215v147,97,248,-3,248,-226v0,-305,-193,-489,-501,-489v-319,0,-533,246,-533,568v0,322,211,545,533,541v186,-2,261,-40,366,-129r0,206v-115,65,-237,98,-366,98v-432,0,-735,-290,-735,-716v0,-427,306,-743,735,-743v439,0,703,236,703,667xm666,-472v0,89,128,118,186,59r0,-184v-116,-5,-186,35,-186,125","w":1578},"A":{"d":"1005,0r-107,-297r-502,0r-102,297r-289,0r584,-1485r114,0r589,1485r-287,0xm646,-1037r-176,541r352,0","w":1297,"k":{"y":37,"w":37,"v":37,"Y":183,"W":111,"V":152,"T":194," ":113}},"B":{"d":"1139,-435v0,280,-247,435,-541,435r-448,0r0,-1464v197,-9,336,-14,415,-14v279,-2,485,116,485,376v0,116,-61,208,-184,275v182,63,273,194,273,392xm410,-1256r0,351v40,3,82,4,126,4v169,0,254,-64,254,-191v0,-113,-77,-169,-231,-169v-41,0,-90,2,-149,5xm869,-466v4,-238,-200,-248,-459,-236r0,484v53,5,95,7,128,7v215,-2,328,-54,331,-255","w":1219},"C":{"d":"80,-728v0,-410,273,-762,671,-762v168,0,302,34,403,103r-107,215v-58,-58,-151,-87,-280,-87v-261,0,-417,260,-417,542v0,285,137,511,398,511v138,0,246,-49,324,-148r121,210v-106,113,-261,169,-466,169v-424,2,-647,-313,-647,-753","w":1253},"D":{"d":"541,-1475v417,-6,695,273,695,685v0,527,-254,790,-761,790r-325,0r0,-1464v207,-7,338,-11,391,-11xm546,-231v285,-3,420,-232,420,-543v0,-358,-202,-508,-556,-463r0,1000v42,4,87,6,136,6","w":1316},"E":{"d":"410,-1234r0,343r484,0r0,221r-484,0r0,439r664,0r0,231r-924,0r0,-1465r935,0r0,231r-675,0","w":1165},"F":{"d":"410,-1234r0,343r515,0r0,221r-515,0r0,670r-260,0r0,-1465r965,0r0,231r-705,0","w":1195,"k":{"u":96,"o":96,"e":96,"a":96,"A":113,".":227,",":227}},"G":{"d":"80,-727v0,-445,295,-763,742,-763v161,0,297,48,410,144r-109,209v-49,-47,-213,-122,-307,-122v-298,0,-466,230,-466,539v0,297,168,516,456,514v93,0,169,-25,229,-76r0,-288r-203,0r0,-222r463,0r0,656v-112,96,-331,159,-531,161v-426,3,-684,-318,-684,-752","w":1375},"H":{"d":"993,0r0,-660r-583,0r0,660r-260,0r0,-1465r260,0r0,574r583,0r0,-574r257,0r0,1465r-257,0","w":1400},"I":{"d":"155,0r0,-1465r260,0r0,1465r-260,0","w":570},"J":{"d":"956,-554v-2,382,-146,572,-522,574v-239,2,-405,-135,-417,-359r232,0v22,85,93,128,214,128v190,0,233,-131,233,-335r0,-919r260,0r0,911","w":1091},"K":{"d":"981,0r-408,-624r-163,223r0,401r-260,0r0,-1465r260,0r0,701r498,-701r296,0r-459,640r547,825r-311,0","w":1264},"L":{"d":"150,0r0,-1465r260,0r0,1234r662,0r0,231r-922,0","w":1132,"k":{"y":76,"Y":152,"W":152,"V":152,"T":152," ":76}},"M":{"d":"1516,1r-252,0r-152,-790r-295,809r-93,0r-295,-809r-158,790r-251,0r295,-1466r138,0r317,987r310,-987r137,0","w":1526},"N":{"d":"1111,20r-711,-927r0,908r-250,0r0,-1466r125,0r692,884r0,-884r250,0r0,1485r-106,0","w":1367},"O":{"d":"690,25v-418,-1,-610,-329,-610,-770v0,-395,241,-746,630,-746v436,0,650,296,650,746v0,451,-230,772,-670,770xm710,-1260v-256,0,-360,235,-360,515v0,171,29,304,87,398v58,94,142,141,253,141v287,0,400,-223,400,-539v0,-343,-127,-515,-380,-515","w":1440},"P":{"d":"410,-539r0,539r-260,0r0,-1464v173,-7,275,-11,304,-11v231,0,401,36,508,107v107,71,160,181,160,332v0,336,-198,504,-594,504v-29,0,-69,-2,-118,-7xm410,-770v244,24,446,-12,446,-246v0,-152,-122,-228,-367,-228v-27,0,-54,2,-79,5r0,469","w":1202,"k":{"o":96,"e":96,"a":96,"A":152,".":264,",":264," ":37}},"Q":{"d":"700,-1491v436,0,660,301,660,751v0,350,-115,584,-344,701v73,80,193,120,362,120v62,0,116,-7,161,-20r0,242v-322,45,-599,-81,-720,-278v-482,69,-739,-305,-739,-765v0,-401,232,-751,620,-751xm700,-1259v-256,0,-351,236,-350,519v0,153,31,282,92,385v61,103,147,155,258,155v282,0,390,-233,390,-540v0,-346,-130,-519,-390,-519","w":1452},"R":{"d":"1114,-1048v1,183,-129,339,-271,388r433,660r-300,0r-391,-605v-39,-1,-94,-3,-165,-7r0,612r-270,0r0,-1465v15,0,71,-2,169,-7v98,-5,177,-8,237,-8v372,0,558,144,558,432xm844,-1051v-6,-171,-138,-190,-336,-194v-28,0,-57,2,-88,6r0,407v231,15,432,12,424,-219","w":1251,"k":{"Y":129,"W":89,"V":74,"T":83}},"S":{"d":"967,-383v-2,257,-234,408,-517,408v-137,0,-260,-35,-370,-106r96,-233v103,72,204,108,303,108v153,0,229,-53,229,-160v0,-50,-22,-95,-54,-143v-54,-82,-385,-224,-450,-291v-69,-70,-120,-165,-121,-296v-3,-232,201,-394,444,-394v169,0,294,32,373,95r-79,224v-91,-65,-188,-98,-289,-98v-113,0,-189,65,-189,171v0,84,94,170,279,262v166,83,245,131,311,274v24,53,34,113,34,179","w":1047},"T":{"d":"746,-1234r0,1234r-260,0r0,-1234r-466,0r0,-231r1213,0r0,231r-487,0","w":1253,"k":{"y":154,"w":163,"u":185,"s":227,"r":210,"o":264,"i":76,"e":227,"c":227,"a":227,"O":122,"A":194,";":227,":":227,".":227,"-":159,",":227," ":37}},"U":{"d":"682,25v-328,0,-532,-164,-532,-483r0,-1007r260,0r0,993v-1,158,107,266,270,266v180,0,298,-98,298,-271r0,-988r260,0r0,1008v2,310,-236,482,-556,482","w":1388},"V":{"d":"696,20r-143,0r-548,-1485r286,0r339,990r358,-990r280,0","w":1273,"k":{"y":76,"u":109,"r":101,"o":138,"i":37,"e":113,"a":152,"A":152,";":76,":":76,".":188,"-":113,",":229}},"W":{"d":"1331,20r-107,0r-320,-924r-311,924r-107,0r-481,-1485r271,0r275,884r297,-884r114,0r298,884r274,-884r271,0","w":1810,"k":{"y":18,"u":37,"r":37,"o":37,"e":37,"a":76,"A":111,";":37,":":37,".":171,"-":37,",":179}},"X":{"d":"942,0r-346,-527r-320,527r-271,0r439,-759r-404,-707r266,1r297,495r327,-495r272,0r-464,710r487,755r-283,0","w":1230},"Y":{"d":"759,-601r0,601r-260,0r0,-601r-494,-864r276,0r347,625r348,-625r275,0","w":1256,"k":{"v":113,"u":113,"q":188,"p":152,"o":188,"i":76,"e":188,"a":152,"A":183,";":133,":":113,".":264,"-":188,",":264," ":37}},"Z":{"d":"80,0r0,-84r611,-1150r-601,0r0,-231r955,0r0,84r-613,1150r635,0r0,231r-987,0","w":1147},"[":{"d":"150,420r0,-1930r523,0r0,223r-263,0r0,1484r263,0r0,223r-523,0","w":823},"\\":{"d":"528,0r-536,-1471r206,0r537,1471r-207,0","w":728},"]":{"d":"673,420r-523,0r0,-223r263,0r0,-1484r-263,0r0,-223r523,0r0,1930","w":823},"^":{"d":"812,-907r-214,-358r-218,362r-192,0r358,-568r107,0r356,564r-197,0"},"_":{"d":"-8,334r0,-209r1215,0r0,209r-1215,0"},"`":{"d":"596,-1215r-226,-293r267,0r169,293r-210,0"},"a":{"d":"886,20v-74,2,-138,-70,-155,-127v-42,74,-177,127,-295,127v-222,0,-374,-115,-371,-332v3,-275,230,-400,536,-396v29,0,64,5,104,15v0,-126,-80,-189,-239,-189v-94,0,-173,16,-236,47r-54,-194v86,-41,188,-62,307,-62v359,0,472,144,473,534r0,229v0,143,29,232,86,269v-36,64,-73,77,-156,79xm707,-504v-43,-9,-75,-13,-96,-13v-197,0,-296,65,-296,194v0,96,56,144,167,144v150,0,225,-75,225,-225r0,-100","w":1091},"b":{"d":"1106,-562v0,345,-202,584,-538,582v-99,0,-185,-26,-256,-79r-56,79r-141,0r0,-1490r250,-60r0,500v67,-41,139,-61,218,-61v307,0,523,224,523,529xm514,-192v248,-2,332,-111,332,-361v0,-217,-104,-326,-312,-326v-74,0,-130,21,-169,63r0,559v37,43,86,65,149,65","w":1191},"c":{"d":"65,-526v0,-340,236,-565,585,-565v125,0,233,35,325,105r-107,187v-59,-55,-137,-83,-236,-83v-198,0,-307,147,-307,356v0,225,107,337,321,337v93,0,174,-31,245,-92r92,197v-132,81,-199,102,-383,104v-331,3,-535,-210,-535,-546","w":1048},"d":{"d":"85,-518v0,-319,213,-576,517,-573v81,0,155,17,222,50r0,-429r250,-60r0,1530r-250,0r0,-65v-42,47,-163,85,-258,85v-309,0,-481,-216,-481,-538xm667,-191v44,0,141,-38,157,-65r0,-559v-53,-43,-109,-64,-167,-64v-208,0,-312,137,-312,354v0,223,107,334,322,334","w":1189},"e":{"d":"597,-1091v344,0,589,274,494,632r-765,0v8,170,126,271,306,270v114,0,201,-30,260,-89r97,191v-88,71,-219,107,-394,107v-329,0,-530,-210,-530,-544v0,-317,233,-567,532,-567xm335,-647r526,0v-17,-157,-104,-235,-260,-235v-143,0,-231,78,-266,235","w":1177},"f":{"d":"192,-1071v5,-244,157,-440,397,-439v59,0,132,13,217,39r-74,190v-55,-18,-97,-27,-126,-27v-107,2,-183,114,-169,237r222,0r0,206r-218,0r0,865r-250,0r0,-865r-156,0r0,-206r157,0","w":757},"g":{"d":"998,73v0,231,-253,347,-498,347v-164,0,-312,-48,-445,-145r158,-195v87,80,185,120,292,120v115,1,244,-28,248,-120v7,-145,-282,-75,-405,-75v-172,0,-258,-62,-258,-185v1,-80,80,-154,143,-179v-122,-79,-183,-192,-183,-337v0,-230,202,-397,436,-397v96,0,176,18,241,54r98,-114r173,157r-119,87v41,63,62,137,62,222v0,273,-217,451,-506,391v-10,0,-113,42,-100,66v0,27,23,40,69,40v46,1,176,-30,229,-30v243,0,365,98,365,293xm499,-888v-112,0,-194,81,-194,193v0,122,74,210,194,210v122,0,185,-85,185,-210v0,-106,-78,-193,-185,-193","w":1028},"h":{"d":"656,-1091v269,-1,423,158,423,431r0,660r-251,0r0,-660v2,-131,-93,-219,-224,-219v-83,0,-184,57,-215,110r0,769r-254,0r0,-1470r254,-60r0,527v65,-59,154,-88,267,-88","w":1214},"i":{"d":"186,-1341v0,-78,67,-145,145,-145v78,0,145,67,145,145v0,78,-67,145,-145,145v-78,0,-145,-67,-145,-145xm202,0r0,-866r-137,0r0,-205r390,0r0,1071r-253,0","w":611},"j":{"d":"301,-1341v0,-78,67,-145,145,-145v78,0,145,67,145,145v0,78,-67,145,-145,145v-78,0,-145,-67,-145,-145xm-12,197v232,-6,341,-19,341,-218r0,-844r-193,0r0,-206r443,0r0,1046v-6,338,-223,444,-591,445r0,-223","w":751},"k":{"d":"820,0r-315,-485r-120,127r0,358r-250,0r0,-1470r250,-60r0,870r357,-411r301,0r-362,406r436,665r-297,0","w":1122,"k":{"a":64}},"l":{"d":"178,-1470r250,-60r0,1204v0,132,39,211,118,236v-39,73,-105,110,-198,110v-113,0,-170,-79,-170,-236r0,-1254","w":604},"m":{"d":"1247,-1091v237,0,378,148,378,384r0,707r-250,0r0,-671v0,-141,-63,-211,-189,-211v-76,0,-157,56,-181,109r0,773r-250,0r0,-710v0,-108,-74,-172,-187,-172v-68,0,-158,65,-183,112r0,770r-250,0r0,-1071r172,0r51,94v69,-76,159,-114,269,-114v142,0,249,39,321,116v55,-66,183,-116,299,-116","w":1760},"n":{"d":"662,-1091v258,-1,412,169,412,434r0,657r-250,0r0,-619v-1,-175,-56,-263,-224,-263v-82,0,-178,55,-215,108r0,774r-250,0r0,-1071r180,0r46,100v68,-80,168,-120,301,-120","w":1209},"o":{"d":"580,20v-327,0,-515,-230,-515,-558v0,-315,204,-553,515,-553v329,0,514,220,514,553v0,330,-191,558,-514,558xm580,-887v-174,0,-255,154,-255,349v0,236,85,354,255,354v176,0,254,-155,254,-354v0,-233,-85,-349,-254,-349","w":1159},"p":{"d":"1108,-527v0,341,-196,548,-528,547v-79,0,-150,-16,-215,-47r0,447r-250,0r0,-1491r250,0r0,72v63,-61,140,-92,231,-92v341,0,512,188,512,564xm848,-534v0,-248,-82,-341,-323,-345v-60,0,-113,23,-160,70r0,563v45,37,98,55,159,55v235,-1,324,-107,324,-343","w":1193},"q":{"d":"85,-525v0,-331,220,-568,539,-566v93,0,178,28,254,84r41,-64r162,0r0,1491r-250,0r0,-450v-60,33,-143,50,-248,50v-321,1,-498,-213,-498,-545xm656,-879v-199,-2,-311,149,-311,354v0,223,101,334,303,334v74,0,135,-17,183,-52r0,-574v-45,-41,-103,-62,-175,-62","w":1196},"r":{"d":"607,-882v-123,-1,-222,136,-222,272r0,610r-250,0r0,-1071r250,0r0,98v70,-79,163,-118,279,-118v85,0,151,13,196,39r-106,214v-45,-29,-94,-44,-147,-44","w":875,"k":{"a":64,".":242,",":231}},"s":{"d":"817,-300v0,214,-180,323,-411,320v-171,-2,-209,-24,-337,-89r89,-199v75,59,159,89,253,89v97,0,146,-35,146,-104v0,-41,-15,-74,-44,-100v-29,-26,-86,-57,-171,-92v-185,-77,-277,-184,-277,-322v0,-195,174,-294,377,-294v111,0,216,25,314,75r-72,194v-55,-47,-131,-70,-228,-70v-128,0,-173,115,-88,178v29,22,90,50,184,88v159,64,265,140,265,326","w":882},"t":{"d":"505,20v-215,1,-332,-130,-332,-348r0,-542r-124,0r0,-201r124,0r0,-218r250,-92r0,310r294,0r0,201r-294,0r0,469v2,143,29,210,162,210v60,0,116,-16,168,-49r0,230v-58,20,-141,30,-248,30","w":812},"u":{"d":"570,-189v109,0,226,-70,255,-146r0,-736r250,0r0,1072r-250,0r0,-90v-60,54,-208,109,-317,109v-249,0,-373,-132,-373,-396r0,-695r250,0r0,676v0,137,62,206,185,206","w":1210},"v":{"d":"579,20r-90,0r-484,-1091r274,0r256,654r275,-654r265,0","w":1080,"k":{"i":-64,".":270,",":270}},"w":{"d":"1187,20r-91,0r-294,-658r-293,658r-92,0r-404,-1091r263,0r215,639r262,-639r90,0r271,643r232,-643r246,0","w":1605,"k":{".":199,",":199}},"x":{"d":"823,0r-275,-349r-247,349r-296,0r411,-548r-378,-523r287,0r226,327r252,-327r285,0r-411,523r449,548r-303,0","w":1131},"y":{"d":"609,172v-55,148,-263,252,-478,248r0,-221v193,0,289,-48,289,-145v0,-64,-27,-162,-80,-294r-335,-831r259,0r292,740r263,-740r259,0","w":1093,"k":{".":227,",":227}},"z":{"d":"65,0r0,-85r581,-768r-571,0r0,-218r936,0r0,88r-560,765r566,0r0,218r-952,0","w":1082},"{":{"d":"534,-328v0,127,-121,363,-34,476v64,84,127,73,310,78r0,194r-169,0v-218,3,-425,-112,-425,-318v0,-84,74,-340,74,-424v0,-110,-70,-169,-209,-178r0,-136v139,-10,209,-75,209,-195v0,-75,-74,-298,-74,-373v0,-195,212,-310,416,-306r178,0r0,187r-205,0v-89,0,-134,50,-134,149v0,66,63,259,63,325v0,103,-64,194,-192,275v128,67,192,149,192,246","w":888},"|":{"d":"505,420r0,-1930r206,0r0,1930r-206,0"},"}":{"d":"675,-1204v0,75,-74,298,-74,373v0,120,70,185,209,195r0,136v-139,9,-209,68,-209,178v0,84,74,340,74,424v0,206,-208,322,-425,318r-169,0r0,-194v184,-5,245,6,309,-78v87,-114,-33,-347,-33,-476v0,-97,64,-179,192,-246v-128,-81,-192,-172,-192,-275v0,-66,63,-259,63,-325v0,-99,-45,-149,-134,-149r-205,0r0,-187r178,0v204,-4,416,111,416,306","w":888},"~":{"d":"909,-538v-113,134,-357,-18,-494,-18v-35,0,-64,26,-89,77r-146,0v26,-165,120,-310,316,-257v30,1,179,67,270,67v40,0,69,-26,87,-77r148,0v-25,99,-57,167,-92,208"},"\u00a0":{"w":617,"k":{"Y":37,"T":37,"A":113}}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":1200,"face":{"font-family":"Trebuchet MS","font-weight":700,"font-style":"italic","font-stretch":"normal","units-per-em":"2048","panose-1":"2 11 7 3 2 2 2 9 2 4","ascent":"1638","descent":"-410","x-height":"20","bbox":"-145 -1686 2018 455","underline-thickness":"200","underline-position":"-161","slope":"-10","unicode-range":"U+0020-U+007E"},"glyphs":{" ":{"w":617,"k":{"Y":37,"A":76}},"!":{"d":"442,-424r-132,0r10,-279v8,-300,69,-529,114,-788r297,0v-53,291,-51,350,-160,678xm330,20v-89,0,-167,-72,-167,-161v0,-89,79,-161,167,-161v88,0,167,73,167,161v0,89,-78,161,-167,161","w":752},"\"":{"d":"773,-1086r-200,0r52,-381r260,0xm363,-1086r-200,0r52,-381r260,0","w":800},"#":{"d":"1174,-910r-215,0r-84,320r154,0r0,181r-202,0r-120,429r-195,0r118,-429r-230,0r-118,429r-195,0r118,-429r-140,0r0,-181r189,0r83,-320r-157,0r0,-181r205,0r108,-396r193,0r-105,396r229,0r108,-396r193,0r-104,396r167,0r0,181xm769,-910r-237,0r-84,320r235,0"},"$":{"d":"1025,-1180v-72,-57,-151,-86,-236,-86v-161,0,-241,61,-241,183v0,54,43,113,128,178v105,79,179,137,220,173v78,68,146,189,145,332v-1,258,-177,396,-420,425r-29,156r-227,0r29,-161v-89,-14,-171,-39,-246,-75r84,-259v89,68,193,102,311,102v197,0,279,-134,197,-274v-19,-33,-50,-64,-88,-95r-245,-190v-85,-83,-128,-178,-128,-285v0,-240,154,-396,369,-431r37,-199r227,0r-36,194v102,7,178,24,229,49"},"%":{"d":"843,-1222v0,235,-155,454,-386,454v-172,0,-258,-86,-258,-259v0,-245,155,-464,394,-464v167,0,250,90,250,269xm562,-1327v-110,0,-164,148,-164,269v0,84,26,126,79,126v122,-1,172,-149,171,-283v0,-75,-29,-112,-86,-112xm310,20r-208,0r1190,-1511r207,0xm1414,-434v0,235,-155,454,-386,454v-172,0,-258,-87,-258,-260v0,-246,156,-463,395,-463v166,0,249,90,249,269xm1133,-539v-110,-1,-164,149,-164,268v0,85,26,127,79,127v122,-1,172,-149,171,-284v0,-74,-29,-111,-86,-111","w":1500},"&":{"d":"790,-1292v-169,-1,-285,85,-284,249v0,54,21,101,64,140r337,0r32,-173r257,-37r-41,213r248,0r-37,209r-250,0v-39,186,-65,238,-65,396v0,65,29,97,86,97v46,0,105,-26,177,-78r0,247v-114,57,-354,79,-446,-14v-105,42,-217,63,-337,63v-237,0,-414,-131,-414,-363v0,-191,76,-354,229,-487v-57,-73,-85,-145,-85,-216v-2,-288,226,-445,524,-445v120,0,214,21,283,62r-65,221v-61,-56,-132,-84,-213,-84xm512,-691v-89,92,-133,194,-133,307v0,124,77,186,230,186v76,0,137,-12,184,-36v11,-161,53,-306,76,-457r-357,0","w":1446},"'":{"d":"475,-1086r-200,0r52,-381r260,0","w":617},"(":{"d":"495,455v-237,-176,-356,-426,-356,-749v0,-240,63,-477,188,-710v125,-233,285,-401,479,-502r0,150v-261,276,-392,691,-392,1246v0,153,27,282,81,387r0,178","w":752},")":{"d":"311,-1493v240,99,367,394,365,741v-4,530,-321,999,-686,1207r0,-179v243,-167,410,-793,410,-1211v0,-167,-30,-307,-89,-418r0,-140","w":752},"*":{"d":"782,-1102r-133,11r137,78r86,111r-193,144r-84,-122r-53,-128r-50,114r-111,136r-172,-154r119,-115r110,-57r-135,-12r-156,-62r98,-205r158,67r71,76r-54,-155r0,-135r236,0r0,131r-46,162r100,-89r141,-62r82,201","w":885},"+":{"d":"713,-535r0,355r-201,0r0,-355r-348,0r0,-201r348,0r0,-343r201,0r0,343r349,0r0,201r-349,0"},",":{"d":"373,-297v93,0,177,96,177,191v0,201,-107,375,-322,520r-77,-101v106,-78,159,-166,159,-263v0,-37,-19,-71,-58,-101v-39,-30,-58,-62,-58,-97v-2,-88,88,-149,179,-149","w":752},"-":{"d":"88,-476r42,-235r529,0r-42,235r-529,0","w":752},"\u2010":{"d":"88,-476r42,-235r529,0r-42,235r-529,0","w":752},".":{"d":"363,20v-86,0,-159,-73,-159,-159v0,-86,73,-159,159,-159v86,0,159,73,159,159v0,86,-73,159,-159,159","w":752},"\/":{"d":"226,0r-236,0r556,-1471r234,0","w":813},"0":{"d":"501,20v-265,0,-410,-179,-410,-450v0,-305,60,-559,181,-760v121,-201,290,-301,509,-301v269,0,403,145,403,435v0,331,-58,593,-174,786v-116,193,-285,290,-509,290xm361,-466v0,171,52,257,156,257v128,0,226,-80,294,-240v68,-160,102,-356,102,-589v0,-149,-55,-224,-166,-224v-117,0,-211,86,-281,256v-70,170,-105,350,-105,540"},"1":{"d":"701,0r-271,0r190,-1024r-293,143r40,-265v237,-105,399,-214,486,-325r120,0"},"2":{"d":"673,-1491v250,0,443,109,444,344v0,67,-19,137,-59,210v-108,196,-384,499,-542,698r524,0r-45,239r-952,0r0,-84r582,-683v133,-164,153,-156,205,-283v54,-131,-6,-219,-181,-219v-82,0,-158,50,-228,150r-184,-122v77,-167,223,-250,436,-250"},"3":{"d":"1092,-1140v-2,165,-116,299,-240,359v109,59,164,154,164,285v0,344,-203,516,-608,516v-144,0,-263,-50,-356,-150r130,-225v76,97,162,146,259,146v174,0,306,-109,306,-280v0,-120,-95,-180,-285,-180r41,-222v209,0,313,-74,313,-223v0,-99,-60,-148,-179,-148v-68,0,-136,27,-203,81r-130,-163v97,-98,223,-147,378,-147v230,0,413,128,410,351"},"4":{"d":"985,-595r148,0r-39,214r-148,0r-70,381r-271,0r70,-381r-657,0r29,-158r974,-932r126,0xm408,-595r306,0r66,-356"},"5":{"d":"805,-619v0,-120,-95,-193,-217,-193v-88,0,-167,38,-237,114r-112,-52r125,-721r800,0r-43,229r-539,0r-45,246v258,-93,534,79,534,331v0,457,-212,685,-635,685v-137,0,-250,-42,-338,-126r113,-232v50,61,155,127,254,129v212,4,340,-193,340,-410"},"6":{"d":"1095,-573v0,316,-240,598,-553,598v-284,0,-426,-144,-426,-432v0,-458,445,-1017,813,-1088r120,155v-171,67,-387,272,-499,421v47,-15,98,-23,153,-23v236,-2,392,136,392,369xm660,-713v-183,0,-279,145,-279,334v0,117,59,175,176,175v160,0,268,-168,268,-330v0,-107,-60,-179,-165,-179"},"7":{"d":"469,0r-320,0v137,-267,396,-674,776,-1223r-678,0r46,-248r1021,0r0,119v-349,469,-631,920,-845,1352"},"8":{"d":"1139,-1173v-2,172,-119,319,-243,385v112,85,168,191,168,317v0,327,-188,491,-563,491v-236,0,-426,-128,-424,-357v2,-236,138,-401,312,-482v-83,-73,-125,-163,-125,-272v0,-238,245,-400,488,-400v204,0,390,120,387,318xm872,-1143v0,-71,-78,-119,-150,-119v-123,0,-185,57,-185,170v0,73,57,134,171,183v109,-89,164,-167,164,-234xm531,-209v159,0,263,-97,261,-256v0,-89,-56,-163,-168,-220v-144,33,-280,151,-282,314v-2,98,89,162,189,162"},"9":{"d":"703,-1491v270,0,426,178,426,452v0,228,-80,447,-241,657v-161,210,-352,346,-573,411r-119,-155v158,-55,414,-286,499,-420v-45,15,-96,22,-154,22v-219,0,-391,-169,-391,-388v0,-340,216,-579,553,-579xm688,-1262v-171,0,-268,153,-268,330v0,119,55,179,164,179v186,1,279,-141,279,-334v0,-117,-58,-175,-175,-175"},":":{"d":"323,20v-86,0,-159,-73,-159,-159v0,-86,73,-159,159,-159v86,0,159,73,159,159v0,86,-73,159,-159,159xm449,-753v-86,0,-159,-73,-159,-159v0,-86,73,-159,159,-159v86,0,159,73,159,159v0,86,-73,159,-159,159","w":752},";":{"d":"373,-297v92,0,177,97,177,191v0,201,-107,375,-322,520r-77,-101v106,-78,159,-166,159,-263v0,-37,-19,-71,-58,-101v-39,-30,-58,-62,-58,-97v-2,-87,88,-149,179,-149xm449,-753v-86,0,-159,-73,-159,-159v0,-86,73,-159,159,-159v86,0,159,73,159,159v0,86,-73,159,-159,159","w":752},"<":{"d":"192,-557r0,-161r799,-383r0,228r-528,236r528,239r0,228"},"=":{"d":"179,-745r0,-201r898,0r0,201r-898,0xm179,-325r0,-201r898,0r0,201r-898,0"},">":{"d":"265,-170r0,-228r527,-239r-527,-236r0,-228r799,383r0,161"},"?":{"d":"474,-1491v190,0,327,111,325,298v-2,135,-65,252,-145,321v-92,80,-251,204,-307,288v-37,56,-47,98,-44,169r-146,0v-33,-149,-13,-264,92,-373v89,-93,215,-179,279,-289v58,-100,39,-217,-111,-217v-74,0,-142,24,-204,71r-85,-169v75,-66,191,-99,346,-99xm223,20v-89,0,-167,-72,-167,-161v0,-89,79,-161,167,-161v88,0,167,73,167,161v0,89,-78,161,-167,161","w":813},"@":{"d":"1560,-801v0,279,-179,572,-451,572v-87,0,-155,-26,-204,-79v-61,60,-136,90,-223,90v-159,1,-269,-95,-269,-254v0,-252,214,-493,468,-493v66,0,159,25,279,76v-62,241,-87,259,-87,425v0,47,17,71,52,71v155,0,230,-205,230,-375v0,-240,-184,-397,-426,-397v-389,0,-665,323,-665,716v0,266,189,454,455,454v140,0,303,-53,370,-128r117,143v-103,91,-324,165,-509,165v-365,0,-637,-249,-637,-612v0,-512,381,-918,891,-918v353,0,609,199,609,544xm874,-812v-138,-5,-241,187,-241,329v0,128,146,109,201,43v75,-91,72,-192,106,-347v-19,-17,-41,-25,-66,-25","w":1578},"A":{"d":"918,0r-46,-298r-524,0r-172,298r-271,0r890,-1485r93,0r301,1485r-271,0xm760,-1040r-301,547r384,0","w":1257,"k":{"Y":239,"W":153,"V":205,"T":185," ":76}},"B":{"d":"1167,-1127v-1,141,-102,260,-206,309v97,39,176,187,176,324v0,169,-61,294,-178,380v-174,128,-554,142,-905,114r268,-1463v112,-16,212,-24,299,-24v364,0,546,120,546,360xm485,-902v221,21,419,-31,421,-232v0,-88,-77,-132,-232,-132v-32,0,-74,2,-126,6xm451,-714r-94,501v253,23,516,-34,516,-260v0,-163,-107,-245,-321,-245v-33,0,-67,1,-101,4","w":1208},"C":{"d":"113,-538v0,-507,318,-952,811,-952v118,0,223,19,314,58r-73,249v-222,-149,-482,-85,-631,133v-99,145,-152,302,-152,476v0,213,109,372,314,371v153,0,274,-42,361,-125r-5,229v-95,83,-231,124,-409,124v-318,0,-530,-241,-530,-563","w":1255},"D":{"d":"1285,-892v5,535,-355,899,-888,892r-354,0r267,-1462v97,-17,189,-26,274,-26v423,-3,698,191,701,596xm1013,-903v0,-248,-221,-400,-486,-348r-178,1018v425,47,664,-270,664,-670","w":1295},"E":{"d":"1212,-1237r-675,0r-61,337r484,0r-41,218r-484,0r-82,454r664,0r-43,228r-932,0r270,-1465r943,0","w":1215},"F":{"d":"1240,-1237r-705,0r-61,337r515,0r-41,218r-515,0r-125,682r-267,0r272,-1465r969,0","w":1199,"k":{"A":293,".":300,",":300}},"G":{"d":"354,-584v0,235,139,382,370,381v95,0,179,-26,250,-79r53,-290r-203,0r40,-218r461,0r-121,657v-151,105,-335,158,-553,158v-329,0,-567,-245,-567,-571v0,-564,337,-944,892,-944v149,0,260,33,333,100r-78,217v-98,-59,-196,-89,-293,-89v-358,0,-584,311,-584,678","w":1385},"H":{"d":"1162,0r-263,0r125,-682r-582,0r-125,682r-264,0r269,-1465r264,0r-104,565r582,0r104,-565r265,0","w":1389},"I":{"d":"329,0r-261,0r269,-1465r262,0","w":570},"J":{"d":"303,20v-207,0,-345,-136,-306,-356r229,0v-1,85,34,128,107,128v112,0,186,-37,223,-112v18,-38,38,-115,59,-230r167,-915r258,0r-168,916v-42,229,-106,382,-194,457v-88,75,-213,112,-375,112","w":1021},"K":{"d":"815,-821r364,821r-293,0r-274,-626r-208,229r-74,397r-260,0r269,-1465r260,0r-121,666r608,-666r308,0","w":1331},"L":{"d":"974,0r-924,0r269,-1465r262,0r-227,1237r662,0","w":1082,"k":{"Y":365,"W":266,"V":313,"T":299," ":37}},"M":{"d":"1240,0r-17,-793r-445,813r-91,0r-145,-821r-307,801r-251,0r544,-1465r146,0r148,929r484,-929r150,0r42,1465r-258,0","w":1610},"N":{"d":"1113,20r-101,0r-540,-947r-162,927r-258,0r269,-1465r120,0r529,908r159,-908r257,0","w":1352},"O":{"d":"600,25v-317,0,-501,-244,-501,-570v0,-261,71,-484,213,-669v142,-185,328,-277,556,-277v349,-1,547,193,547,543v0,543,-292,973,-815,973xm369,-572v-1,203,75,369,263,369v159,0,284,-71,376,-214v92,-143,138,-313,138,-511v0,-224,-99,-336,-296,-336v-139,0,-253,73,-344,220v-91,147,-137,304,-137,472","w":1438},"P":{"d":"1225,-1048v0,397,-389,589,-811,510r-99,538r-266,0r276,-1463v139,-15,246,-22,319,-22v387,0,581,146,581,437xm585,-746v208,1,369,-87,370,-283v0,-154,-87,-231,-262,-231v-47,0,-97,6,-151,17r-87,483v34,9,77,14,130,14","w":1195,"k":{"A":212,".":344,",":344," ":76}},"Q":{"d":"1291,372v-245,-1,-441,-161,-510,-354v-50,12,-104,18,-163,18v-332,1,-502,-232,-502,-575v0,-262,71,-487,213,-673v142,-186,327,-279,556,-279v348,0,547,198,547,546v0,412,-168,764,-454,892v80,170,414,247,594,108r96,156v-85,107,-211,161,-377,161xm386,-566v-1,207,74,372,264,372v158,0,283,-72,375,-215v92,-143,138,-315,138,-515v0,-225,-98,-338,-295,-338v-139,0,-254,74,-345,222v-91,148,-137,305,-137,474","w":1576},"R":{"d":"1214,-1124v3,245,-160,430,-369,475r327,649r-293,0r-280,-606v-45,-1,-101,-3,-167,-8r-113,614r-268,0r268,-1465v195,-10,322,-15,383,-15v282,-1,509,100,512,356xm954,-1064v0,-162,-123,-183,-313,-186v-9,0,-41,3,-95,10r-75,410v39,4,74,6,105,6v252,0,378,-80,378,-240","w":1277,"k":{"Y":217,"W":124,"T":157}},"S":{"d":"208,-951v-84,-318,161,-539,471,-539v84,0,288,26,341,54r-80,260v-77,-57,-156,-85,-236,-85v-161,0,-241,61,-241,182v0,103,196,240,279,312v103,89,163,132,199,263v92,334,-198,529,-526,529v-131,0,-255,-28,-372,-85r84,-257v89,67,193,101,311,101v129,1,248,-54,248,-175v0,-55,-43,-116,-128,-183r-157,-125v-106,-82,-159,-123,-193,-252","w":1027},"T":{"d":"1391,-1237r-462,0r-226,1237r-263,0r226,-1237r-466,0r42,-228r1192,0","w":1403,"k":{"y":256,"w":256,"u":244,"s":283,"r":230,"o":229,"i":110,"e":256,"c":256,"a":256,"O":137,"A":185,";":225,":":225,".":365,"-":253,",":365}},"U":{"d":"399,-467v-30,163,66,266,222,264v187,-2,305,-113,336,-278r183,-984r264,0r-187,1014v-50,292,-290,476,-626,476v-296,0,-515,-171,-457,-487r184,-1003r268,0","w":1355},"V":{"d":"674,20r-142,0r-294,-1485r278,0r175,972r514,-972r291,0","w":1399,"k":{"y":117,"u":117,"r":130,"o":169,"i":96,"e":169,"a":169,"A":205,";":149,":":149,".":308,"-":123,",":308}},"W":{"d":"1272,20r-105,0r-159,-894r-475,894r-105,0r-207,-1485r265,0r111,888r462,-888r113,0r136,882r428,-882r282,0","w":1897,"k":{"y":97,"u":84,"r":77,"o":110,"i":71,"e":110,"a":144,"A":220,";":163,":":163,".":350,"-":136,",":350}},"X":{"d":"848,-741r345,741r-287,0r-232,-517r-394,517r-303,0r588,-772r-279,-694r268,1r189,488r395,-488r303,0","w":1345},"Y":{"d":"848,-648r-119,648r-258,0r121,-656r-345,-809r271,0r236,573r439,-573r297,0","w":1400,"k":{"v":169,"u":225,"q":200,"p":156,"o":200,"i":116,"e":200,"a":176,"A":239,";":200,":":200,".":325,"-":225,",":325," ":37}},"Z":{"d":"482,-228r597,0r-43,228r-949,0r0,-83r793,-1154r-602,0r42,-228r928,0r0,83","w":1252},"[":{"d":"923,-1278r-263,0r-267,1466r263,0r-43,232r-544,0r353,-1930r544,0","w":994},"\\":{"d":"710,0r-539,-1471r216,0r540,1471r-217,0","w":978},"]":{"d":"552,420r-544,0r43,-232r263,0r267,-1466r-263,0r43,-232r544,0","w":994},"^":{"d":"887,-907r-214,-358r-218,362r-192,0r358,-568r107,0r356,564r-197,0"},"_":{"d":"-8,334r0,-209r1215,0r0,209r-1215,0"},"`":{"d":"637,-1285r-153,-333r280,0r35,333r-162,0"},"a":{"d":"71,-351v0,-385,273,-740,650,-740v181,0,311,17,391,50r-124,657v-18,126,1,333,27,384r-156,0v-47,0,-81,-36,-104,-107v-85,85,-192,127,-319,127v-231,2,-365,-140,-365,-371xm699,-887v-237,-4,-368,282,-368,530v0,115,57,173,170,173v72,0,135,-44,189,-133v54,-89,101,-272,143,-550v-47,-13,-92,-20,-134,-20","w":1214},"b":{"d":"1156,-625v0,346,-292,645,-638,645v-106,0,-184,-34,-234,-101r-80,81r-183,0v64,-163,108,-310,131,-440r190,-1070r244,0r-84,479v62,-40,138,-60,227,-60v264,0,427,196,427,466xm512,-187v229,0,378,-189,378,-423v0,-180,-86,-270,-258,-270v-67,0,-125,29,-174,86r-97,529v25,52,76,78,151,78","w":1215},"c":{"d":"75,-402v0,-382,250,-689,626,-689v107,0,199,22,277,66r-51,219v-70,-51,-141,-77,-212,-77v-235,0,-381,208,-381,450v0,126,86,242,211,242v89,0,194,-38,315,-114r-30,261v-102,43,-207,64,-315,64v-265,0,-440,-159,-440,-422","w":1009},"d":{"d":"690,-1091v68,0,183,35,218,67r92,-486r242,0r-273,1510r-249,0r19,-100v-55,80,-147,120,-275,120v-249,0,-400,-161,-400,-411v0,-391,242,-700,626,-700xm707,-880v-237,-3,-378,205,-378,450v0,163,67,244,202,244v145,0,240,-116,283,-348r48,-256v-32,-60,-84,-90,-155,-90","w":1215},"e":{"d":"1104,-815v2,327,-437,458,-761,350v-36,237,190,334,394,243v54,-24,98,-49,129,-78r-29,263v-85,38,-188,57,-310,57v-269,2,-444,-189,-444,-468v0,-365,270,-643,642,-643v205,0,378,85,379,276xm391,-654v115,34,278,21,371,-22v63,-28,94,-68,94,-120v0,-58,-63,-87,-190,-87v-123,0,-232,125,-275,229","w":1130},"f":{"d":"929,-1271v-185,-84,-283,-22,-337,200r246,0r-25,201r-252,0r-160,938v-27,191,-198,352,-410,352r-53,-166v91,-19,181,-104,198,-196r167,-928r-151,0r33,-201r148,0v69,-293,225,-439,469,-439v69,0,128,14,177,43","w":840,"k":{"f":90}},"g":{"d":"114,-606v-4,-287,221,-485,510,-485v92,0,170,20,233,59r94,-102r147,146r-103,103v47,124,15,291,-45,390v-46,76,-120,138,-223,185v-103,47,-160,79,-170,96v199,-53,376,52,376,230v0,284,-220,406,-532,404v-139,-1,-319,-66,-401,-132r109,-189v95,68,194,102,297,102v185,0,278,-50,278,-150v0,-57,-54,-74,-115,-85r-191,-34v-71,-22,-107,-63,-107,-124v0,-35,29,-71,88,-107v-129,-34,-243,-155,-245,-307xm610,-887v-148,0,-242,111,-242,259v0,97,45,181,135,182v150,2,254,-145,254,-300v0,-94,-49,-141,-147,-141","w":1096},"h":{"d":"762,-1091v243,0,366,183,318,436r-123,655r-257,0r126,-665v24,-121,-19,-215,-144,-215v-90,0,-171,38,-243,114r-142,766r-255,0r272,-1510r249,0r-82,504v89,-57,182,-85,281,-85","w":1151},"i":{"d":"486,-1259v-87,0,-163,-69,-163,-156v0,-88,75,-156,163,-156v87,0,163,69,163,156v0,86,-77,156,-163,156xm397,0r-254,0r162,-870r-137,0r42,-201r387,0","w":669},"j":{"d":"607,-1256v-87,0,-163,-70,-163,-157v0,-88,75,-158,163,-158v88,0,163,70,163,158v0,87,-76,157,-163,157xm512,-15v-65,317,-257,435,-657,435r11,-221v234,3,365,-37,398,-220r152,-849r-144,0r47,-201r389,0","w":794},"k":{"d":"763,0r-339,-441r-42,35r-71,406r-251,0r262,-1510r246,0r-129,795v131,-113,380,-323,445,-420r175,151v-29,36,-177,171,-442,405r442,579r-296,0","w":1105},"l":{"d":"351,-209v0,75,54,126,126,125v-39,63,-99,94,-179,94v-121,0,-194,-91,-194,-212v0,-81,16,-198,48,-351r201,-957r248,0r-206,997v-29,142,-44,243,-44,304","w":655},"m":{"d":"1650,-702r-131,702r-256,0r127,-676v23,-117,-15,-207,-141,-207v-75,0,-173,66,-204,114r-143,769r-256,0r142,-755v33,-129,-165,-160,-266,-93v-39,26,-72,51,-96,82r-143,766r-255,0r145,-774v11,-86,3,-197,-23,-277r245,-43v9,34,16,66,22,97v143,-127,498,-130,602,21v85,-77,191,-115,320,-115v251,0,355,150,311,389","w":1700},"n":{"d":"947,0r-259,0r117,-624v9,-50,14,-92,14,-126v0,-89,-52,-133,-157,-133v-89,0,-170,38,-241,113r-143,770r-251,0r151,-803v11,-84,-1,-162,-25,-248r245,-45r23,120v88,-77,198,-115,331,-115v220,0,330,103,330,309v0,37,-5,80,-14,130","w":1151},"o":{"d":"501,20v-269,0,-429,-151,-429,-421v0,-369,263,-690,625,-690v270,0,431,146,431,413v0,377,-256,698,-627,698xm670,-887v-215,0,-338,249,-338,474v0,153,66,229,197,229v222,0,338,-252,338,-487v0,-144,-66,-216,-197,-216","w":1167},"p":{"d":"1157,-675v0,392,-254,695,-641,695v-77,0,-147,-16,-211,-49r-80,449r-250,0r216,-1160v19,-102,14,-204,-6,-306r244,-44v9,25,17,59,23,102v93,-69,185,-103,276,-103v286,0,429,139,429,416xm895,-650v0,-181,-187,-279,-351,-192v-44,23,-78,45,-100,71r-100,529v33,34,81,51,145,51v272,0,406,-178,406,-459","w":1226},"q":{"d":"700,-1091v83,0,216,47,255,93v53,-71,97,-77,236,-74v-37,92,-67,205,-92,339r-213,1153r-251,0r86,-474v-72,49,-158,74,-257,74v-255,2,-415,-154,-415,-409v0,-385,269,-702,651,-702xm313,-434v0,152,93,244,245,243v79,0,145,-18,198,-54r107,-576v-40,-39,-93,-59,-159,-59v-238,0,-391,204,-391,446","w":1226},"r":{"d":"869,-817v-123,-96,-231,-86,-335,19v-55,55,-87,120,-101,193r-113,605r-251,0r200,-1071r251,0r-17,93v139,-106,238,-138,441,-94","w":915,"k":{".":233,",":233}},"s":{"d":"155,-750v-4,-216,207,-341,430,-341v83,0,190,28,322,84r-116,229v-80,-70,-153,-105,-220,-105v-73,0,-153,36,-153,105v0,86,223,169,275,202v68,43,132,111,132,215v3,246,-216,381,-471,381v-117,0,-232,-33,-344,-99r132,-227v83,79,165,118,245,118v94,0,176,-51,175,-141v0,-36,-33,-68,-94,-103v-131,-74,-309,-123,-313,-318","w":940},"t":{"d":"435,20v-187,0,-305,-156,-261,-353r121,-537r-124,0r43,-201r124,0r42,-219r286,-104r-75,323r293,0r-43,201r-295,0r-108,475v-30,111,-14,205,111,205v37,0,97,-17,180,-52r0,225v-72,25,-170,37,-294,37","w":897},"u":{"d":"357,20v-220,0,-327,-171,-284,-401r129,-690r254,0r-127,680v-27,119,10,203,138,203v161,0,277,-127,300,-264r110,-619r251,0r-200,1072r-250,0r15,-78v-89,65,-201,97,-336,97","w":1141},"v":{"d":"511,20r-90,0r-328,-1091r261,0r180,649r377,-649r290,0","w":1131,"k":{".":300,",":300}},"w":{"d":"1064,20r-90,0r-187,-619r-401,619r-92,0r-211,-1091r254,0r107,590r367,-590r90,0r177,597r309,-597r265,0","w":1584,"k":{".":196,",":196}},"x":{"d":"755,-538r311,538r-305,0r-176,-333r-285,333r-308,0r466,-559r-284,-512r292,0r169,325r258,-325r315,0","w":1179},"y":{"d":"620,107v-99,207,-292,312,-578,313r0,-241v189,-1,310,-62,363,-183r52,-120v-91,-26,-153,-122,-185,-288r-127,-659r263,0v78,469,128,714,149,735r344,-735r283,0","w":1155,"k":{".":189,",":189}},"z":{"d":"447,-217r508,0r-41,217r-886,0r0,-85r626,-769r-525,0r41,-217r892,0r0,89","w":1091},"{":{"d":"386,-1128v0,-238,228,-378,476,-374r190,0r-36,196r-151,-3v-168,0,-216,58,-220,214v-1,37,16,151,16,188v0,134,-81,247,-242,340v96,55,144,127,144,216v0,88,-149,349,-136,437v-13,113,151,143,311,131r-36,203r-169,0v-197,2,-373,-90,-382,-274v-5,-105,159,-408,159,-511v0,-77,-61,-120,-182,-128r26,-143v167,-12,250,-99,250,-262v0,-46,-18,-185,-18,-230","w":994},"|":{"d":"505,420r0,-1930r206,0r0,1930r-206,0"},"}":{"d":"868,-1235v5,95,-150,365,-150,459v0,85,60,132,180,141r-26,143v-167,11,-250,100,-250,268v0,45,14,188,14,233v0,265,-216,415,-490,411r-181,0r36,-203v250,5,380,-40,382,-272v1,-37,-12,-157,-12,-194v0,-142,80,-250,240,-324v-95,-71,-142,-148,-142,-230v0,-86,130,-325,130,-411v0,-61,-34,-92,-102,-92r-217,0r36,-196r177,0v190,-3,366,90,375,267","w":994},"~":{"d":"909,-538v-113,134,-357,-18,-494,-18v-35,0,-64,26,-89,77r-146,0v26,-165,120,-310,316,-257v30,1,179,67,270,67v40,0,69,-26,87,-77r148,0v-25,99,-57,167,-92,208"},"\u00a0":{"w":617,"k":{"Y":37,"A":76}}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2006 Microsoft Corporation. All Rights Reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corporation
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":1074,"face":{"font-family":"Trebuchet MS","font-weight":400,"font-style":"italic","font-stretch":"normal","units-per-em":"2048","panose-1":"2 11 6 3 2 2 2 9 2 4","ascent":"1638","descent":"-410","x-height":"20","bbox":"-139 -1686 1905 428","underline-thickness":"127","underline-position":"-198","slope":"-10","unicode-range":"U+0020-U+007E"},"glyphs":{" ":{"w":617,"k":{"Y":37,"A":76}},"!":{"d":"351,-382r-71,0v4,-243,10,-406,18,-490v23,-237,65,-403,100,-619r226,0v-78,459,-88,561,-273,1109xm132,-121v0,-77,65,-142,142,-142v77,0,142,65,142,142v0,77,-65,141,-142,141v-77,0,-142,-64,-142,-141","w":752},"\"":{"d":"326,-1086r-133,0r43,-381r184,0xm656,-1086r-133,0r43,-381r184,0","w":665},"#":{"d":"937,-947r-99,393r161,0r0,128r-194,0r-124,446r-127,0r124,-446r-297,0r-124,446r-130,0r123,-446r-155,0r0,-128r188,0r99,-393r-172,0r0,-128r205,0r102,-412r131,0r-103,412r297,0r103,-412r127,0r-103,412r175,0r0,128r-207,0xm513,-947r-99,393r297,0r99,-393r-297,0"},"$":{"d":"715,-1320v-160,0,-277,72,-276,225v1,73,42,128,87,167v27,23,82,64,164,127v141,108,242,202,242,414v0,253,-172,388,-415,409r-28,159r-156,0r28,-162v-102,-13,-184,-35,-245,-66r60,-192v54,44,193,82,293,82v148,0,264,-76,263,-218v0,-57,-19,-105,-54,-150v-67,-87,-314,-241,-378,-337v-92,-136,-68,-377,38,-488v68,-71,154,-118,266,-134r36,-202r156,0r-35,198v119,7,195,20,228,37r-57,194v-35,-30,-148,-63,-217,-63","w":985},"%":{"d":"143,20r-127,0r1149,-1511r126,0xm697,-1246v0,226,-124,442,-348,442v-151,0,-226,-81,-226,-243v0,-117,28,-221,84,-310v56,-89,147,-134,272,-134v145,0,218,82,218,245xm458,-1389v-135,1,-208,175,-208,325v0,105,36,158,108,158v76,0,130,-38,164,-113v34,-75,51,-151,51,-227v0,-95,-38,-143,-115,-143xm1226,-425v0,223,-123,442,-349,442v-151,0,-226,-81,-226,-242v0,-119,28,-222,84,-311v56,-89,147,-134,272,-134v146,0,219,82,219,245xm986,-568v-135,0,-208,182,-208,325v0,105,36,158,108,158v76,0,130,-38,164,-113v34,-75,51,-151,51,-227v0,-95,-38,-143,-115,-143","w":1229},"&":{"d":"787,-1341v-188,-2,-314,103,-313,287v0,67,27,125,82,173r372,0r32,-183r197,-29r-40,215r249,0r-28,160r-249,0r-39,189v-18,85,-31,162,-31,250v0,86,38,129,115,129v53,0,102,-17,148,-52r0,182v-52,27,-127,40,-224,40v-77,0,-139,-24,-188,-71v-105,47,-219,71,-342,71v-224,0,-386,-129,-386,-348v0,-201,80,-368,240,-502v-64,-76,-96,-152,-96,-227v-2,-278,211,-434,496,-434v116,0,199,16,250,48r-54,186v-59,-56,-123,-84,-191,-84xm347,-371v-1,145,110,223,259,221v91,0,161,-16,212,-49v-1,-41,2,-71,10,-115r71,-404r-398,0v-103,107,-154,222,-154,347","w":1446},"'":{"d":"325,-1086r-133,0r43,-381r184,0","w":327},"(":{"d":"460,428v-165,-123,-286,-414,-286,-705v0,-223,59,-457,176,-701v117,-244,258,-409,421,-497r0,83v-256,277,-393,769,-392,1305v0,165,27,301,81,410r0,105","w":752},")":{"d":"346,-1475v190,76,295,437,295,715v0,225,-58,451,-174,679v-116,228,-263,398,-442,509r0,-105v236,-165,410,-861,410,-1273v0,-179,-30,-327,-89,-442r0,-83","w":752},"*":{"d":"714,-1127r-173,3r158,105r47,62r-122,104r-54,-70r-82,-159r-91,162r-43,64r-131,-101r50,-69r158,-83r-176,-27r-90,-32r72,-150r96,37r125,95r-63,-205r0,-79r176,1r0,75r-60,211r158,-107r74,-27r57,161","w":752},"+":{"d":"611,-706r349,0r0,141r-349,0r0,345r-141,0r0,-345r-348,0r0,-141r348,0r0,-343r141,0r0,343"},",":{"d":"370,-290v81,0,145,77,145,158v0,89,-24,169,-73,242v-49,73,-135,148,-260,225r-44,-76v129,-88,193,-168,193,-239v0,-23,-8,-48,-23,-75v-51,-30,-76,-69,-76,-116v-1,-72,64,-119,138,-119","w":752},"-":{"d":"144,-506r30,-175r428,0r-30,175r-428,0","w":752},"\u2010":{"d":"144,-506r30,-175r428,0r-30,175r-428,0","w":752},".":{"d":"165,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},"\/":{"d":"350,0r-161,0r531,-1471r159,0"},"0":{"d":"443,20v-250,0,-375,-176,-375,-436v0,-321,58,-580,172,-778v114,-198,275,-297,483,-297v245,0,368,140,368,420v0,341,-56,608,-167,801v-111,193,-272,290,-481,290xm268,-453v0,202,64,303,191,303v137,0,244,-86,319,-260v75,-174,112,-388,112,-642v0,-179,-67,-269,-201,-269v-127,0,-228,93,-305,277v-77,184,-116,381,-116,591"},"1":{"d":"444,0r195,-1101r-296,151r28,-192v232,-107,389,-217,472,-329r60,0r-259,1471r-200,0"},"2":{"d":"588,-1491v236,0,406,108,409,325v0,66,-16,136,-55,208v-120,221,-406,553,-573,778r544,0r-32,180r-818,0r0,-90r483,-618v95,-123,159,-214,192,-273v33,-59,49,-117,49,-173v1,-109,-108,-164,-223,-164v-92,0,-168,44,-228,133r-140,-92v63,-143,194,-214,392,-214"},"3":{"d":"933,-485v0,361,-196,505,-573,505v-133,0,-238,-42,-313,-127r91,-166v43,61,155,123,255,123v194,0,331,-134,331,-328v0,-149,-89,-223,-268,-223r28,-162v206,0,309,-90,309,-269v1,-122,-80,-190,-204,-189v-77,0,-142,23,-197,69r-90,-118v76,-81,187,-121,332,-121v211,0,377,124,375,332v-2,180,-144,330,-292,375v144,49,216,149,216,299"},"4":{"d":"882,-399r-70,399r-200,0r70,-399r-657,0r20,-114r956,-958r70,0r-162,918r148,0r-27,154r-148,0xm799,-1065r-510,512r420,0"},"5":{"d":"760,-584v0,-140,-95,-246,-232,-246v-91,0,-163,25,-217,74r-103,0r125,-715r729,0r-30,170r-539,0r-63,356v54,-37,120,-55,197,-55v200,0,349,149,349,348v0,448,-200,672,-600,672v-128,0,-227,-35,-296,-104r82,-177v78,74,159,111,243,111v237,1,355,-188,355,-434"},"6":{"d":"1023,-566v0,299,-224,591,-518,591v-261,0,-391,-139,-391,-417v0,-149,28,-289,84,-420v100,-237,407,-621,680,-679r79,107v-117,31,-508,428,-536,547v65,-53,146,-80,245,-80v219,-2,357,132,357,351xm623,-747v-206,0,-314,170,-314,384v0,145,70,218,211,218v178,0,293,-194,293,-380v0,-127,-67,-222,-190,-222"},"7":{"d":"342,0r-242,0v122,-251,384,-678,785,-1281r-701,0r33,-190r957,0r0,78v-345,486,-623,950,-832,1393"},"8":{"d":"84,-329v3,-251,149,-408,346,-486v-84,-46,-159,-170,-159,-292v-2,-238,194,-384,443,-384v187,0,362,117,362,298v0,176,-137,356,-277,398v109,60,202,181,202,336v0,340,-167,476,-518,479v-219,2,-402,-138,-399,-349xm684,-1321v-174,0,-278,210,-158,337v36,38,78,69,129,90v95,-20,214,-155,214,-268v0,-91,-92,-159,-185,-159xm289,-364v0,122,97,214,214,214v197,0,296,-97,296,-292v0,-133,-105,-233,-205,-283v-132,25,-305,202,-305,361"},"9":{"d":"694,-1491v242,0,391,173,391,417v0,258,-88,497,-265,716v-177,219,-343,347,-500,383r-78,-107v116,-31,508,-427,535,-546v-63,53,-145,79,-245,79v-201,0,-356,-165,-356,-371v0,-329,195,-571,518,-571xm575,-719v206,0,314,-169,314,-384v0,-129,-79,-218,-210,-218v-194,0,-293,175,-293,380v0,127,67,222,189,222"},":":{"d":"292,-921v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151xm204,-131v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151","w":752},";":{"d":"292,-921v0,-80,70,-150,150,-150v80,0,150,70,150,150v0,80,-70,151,-150,151v-80,0,-150,-71,-150,-151xm370,-290v81,0,145,77,145,158v0,89,-24,169,-73,242v-49,73,-135,148,-260,225r-44,-76v129,-88,193,-168,193,-239v0,-23,-8,-48,-23,-75v-51,-30,-76,-69,-76,-116v-1,-72,64,-119,138,-119","w":752},"<":{"d":"889,-218r-739,-358r0,-123r739,-354r0,161r-571,255r571,258r0,161"},"=":{"d":"960,-876r0,141r-838,0r0,-141r838,0xm960,-536r0,141r-838,0r0,-141r838,0"},">":{"d":"993,-576r-739,358r0,-161r571,-258r-571,-255r0,-161r739,354r0,123"},"?":{"d":"539,-1491v179,0,300,105,300,283v0,118,-35,232,-131,316r-233,203v-73,65,-133,142,-132,260r-98,0v-33,-142,-10,-253,94,-354r193,-187v59,-57,116,-131,116,-230v0,-92,-55,-138,-166,-138v-80,0,-145,20,-195,60r-63,-130v61,-55,166,-83,315,-83xm146,-121v0,-76,66,-142,142,-142v75,0,142,67,142,142v0,75,-67,141,-142,141v-76,0,-142,-65,-142,-141","w":752},"@":{"d":"1131,-254v-81,0,-180,-42,-202,-101v-28,54,-143,112,-225,112v-142,0,-240,-84,-239,-227v2,-264,235,-530,537,-460v25,6,74,24,145,55v-55,241,-82,379,-82,413v0,68,27,102,82,102v174,-1,250,-220,250,-410v0,-259,-187,-433,-446,-433v-382,0,-685,371,-685,756v0,286,185,459,471,459v154,0,285,-43,393,-128r96,72v-139,119,-310,178,-511,178v-353,0,-593,-209,-593,-559v0,-471,383,-900,851,-900v335,0,569,191,569,521v0,263,-157,550,-411,550xm896,-845v-153,0,-271,210,-271,364v0,84,37,126,112,126v100,1,185,-87,203,-175r55,-270v-27,-30,-60,-45,-99,-45","w":1578},"A":{"d":"936,0r-46,-309r-525,0r-173,309r-224,0r857,-1485r53,0r290,1485r-232,0xm779,-1082r-335,626r425,0","w":1251,"k":{"y":79,"w":150,"v":167,"Y":247,"W":202,"V":252,"T":230," ":76}},"B":{"d":"1138,-1142v0,151,-135,310,-274,321v163,30,244,142,244,336v0,165,-59,289,-174,373v-169,124,-509,141,-847,112r259,-1465v99,-15,191,-22,275,-22v345,0,517,115,517,345xm524,-1305r-66,406v58,5,105,7,141,7v223,0,335,-86,335,-257v0,-110,-87,-165,-260,-165v-33,0,-83,3,-150,9xm324,-170v270,42,577,-45,577,-293v0,-184,-117,-276,-351,-276v-39,0,-81,2,-126,7","w":1159},"C":{"d":"643,25v-327,2,-502,-222,-502,-556v0,-268,73,-495,219,-681v146,-186,333,-278,564,-278v116,0,209,16,280,47r-55,195v-56,-43,-135,-64,-237,-64v-157,0,-290,79,-398,236v-108,157,-161,326,-161,508v0,275,114,413,343,413v118,0,233,-48,344,-145r-16,212v-82,75,-209,113,-381,113","w":1225},"D":{"d":"1247,-898v0,540,-350,898,-860,898r-320,0r258,-1465v82,-15,165,-23,249,-23v410,-1,673,189,673,590xm1032,-909v0,-277,-252,-456,-540,-384r-186,1104v461,69,726,-287,726,-720","w":1256},"E":{"d":"484,-1285r-72,407r484,0r-30,170r-484,0r-93,528r664,0r-32,180r-874,0r259,-1465r885,0r-33,180r-674,0","w":1097},"F":{"d":"492,-1285r-72,407r515,0r-30,170r-515,0r-125,708r-210,0r262,-1465r911,0r-31,180r-705,0","w":1075,"k":{"A":230,".":400,",":400," ":37}},"G":{"d":"112,-539v0,-536,342,-951,864,-951v144,0,244,28,300,84r-60,191v-85,-63,-178,-95,-278,-95v-372,0,-613,342,-613,732v0,282,133,423,399,423v107,0,199,-32,276,-96r61,-343r-203,0r30,-170r403,0r-113,638v-138,101,-314,151,-527,151v-359,0,-539,-188,-539,-564","w":1385},"H":{"d":"913,0r125,-708r-640,0r-125,708r-206,0r259,-1465r206,0r-104,587r640,0r104,-587r204,0r-259,1465r-204,0","w":1340},"I":{"d":"75,0r259,-1465r204,0r-259,1465r-204,0","w":570},"J":{"d":"267,20v-185,0,-305,-118,-280,-313r175,0v0,89,45,133,135,133v86,0,151,-18,196,-54v45,-36,83,-145,114,-325r163,-926r200,0r-161,918v-37,211,-92,357,-166,441v-74,84,-199,126,-376,126","w":976},"K":{"d":"869,0r-284,-674r-244,277r-70,397r-202,0r258,-1465r202,0r-132,758r666,-758r233,0r-550,635r354,830r-231,0","w":1179},"L":{"d":"84,0r259,-1465r204,0r-227,1285r662,0r-32,180r-866,0","w":1037,"k":{"y":89,"Y":249,"W":171,"V":174,"T":213," ":37}},"M":{"d":"1247,0r-20,-906r-487,926r-50,0r-158,-934r-338,914r-190,0r522,-1465r101,0r159,1028r516,-1028r105,0r41,1465r-201,0","w":1559},"N":{"d":"1003,20r-572,-1040r-172,1020r-200,0r259,-1465r80,0r560,998r169,-998r198,0r-262,1485r-60,0","w":1307},"O":{"d":"587,25v-304,0,-473,-249,-473,-563v0,-257,69,-481,206,-670v137,-189,316,-283,535,-283v339,-1,518,194,518,535v0,285,-70,519,-209,704v-139,185,-331,277,-577,277xm327,-566v0,227,85,411,292,411v166,0,297,-77,395,-231v98,-154,147,-337,147,-549v0,-251,-108,-377,-324,-377v-149,0,-272,81,-367,244v-95,163,-143,331,-143,502","w":1380},"P":{"d":"1167,-1059v0,399,-395,591,-805,495r-100,564r-208,0r267,-1465v124,-13,222,-20,294,-20v368,0,552,142,552,426xm556,-717v223,2,398,-107,398,-322v0,-179,-97,-269,-290,-269v-55,0,-113,8,-175,23r-95,541v37,18,91,27,162,27","w":1113,"k":{"A":245,".":400,",":400," ":76}},"Q":{"d":"1359,-956v0,376,-172,816,-441,912v51,209,406,289,594,142r87,151v-50,65,-225,123,-353,123v-267,0,-468,-147,-512,-370v-51,15,-105,23,-161,23v-319,1,-473,-231,-473,-563v0,-257,69,-481,206,-670v137,-189,315,-283,534,-283v338,-1,519,194,519,535xm313,-566v0,227,85,411,292,411v166,0,297,-78,395,-233v98,-155,147,-337,147,-547v0,-251,-108,-377,-324,-377v-145,0,-267,80,-364,240v-97,160,-146,328,-146,506","w":1380},"R":{"d":"1171,-1159v0,247,-174,453,-381,495r273,664r-229,0r-230,-629v-51,0,-122,-3,-211,-10r-112,639r-210,0r258,-1465r359,-15v155,0,274,28,358,83v84,55,125,135,125,238xm957,-1076v5,-224,-219,-233,-450,-209r-84,476v260,41,530,-32,534,-267","w":1192,"k":{"Y":137,"W":89,"V":115,"T":98}},"S":{"d":"903,-387v9,332,-324,470,-662,390v-65,-15,-117,-31,-154,-50r60,-192v54,44,193,82,293,82v148,0,264,-76,263,-218v0,-57,-20,-105,-55,-150v-68,-87,-314,-240,-377,-337v-37,-57,-60,-123,-60,-205v0,-262,190,-423,450,-423v150,0,250,13,299,39r-57,194v-35,-30,-148,-63,-217,-63v-160,0,-277,72,-276,225v1,73,42,128,87,167v27,23,83,64,165,127v141,108,235,202,241,414","w":985},"T":{"d":"828,-1285r-226,1285r-205,0r226,-1285r-466,0r32,-180r1153,0r-32,180r-482,0","w":1189,"k":{"y":195,"w":221,"u":221,"s":223,"r":213,"o":240,"i":53,"e":249,"c":249,"a":249,"O":98,"A":230,";":150,":":150,".":300,"-":230,",":300}},"U":{"d":"573,25v-288,0,-482,-171,-429,-472r180,-1018r210,0r-180,1003v-34,183,74,307,249,307v204,0,331,-130,364,-312r179,-998r206,0r-180,1019v-46,285,-274,471,-599,471","w":1328},"V":{"d":"563,20r-101,0r-284,-1485r220,0r186,1069r544,-1069r227,0","w":1203,"k":{"y":46,"u":80,"r":124,"o":163,"i":54,"e":137,"a":137,"A":250,";":37,":":37,".":273,"-":111,",":273}},"W":{"d":"1187,20r-63,0r-169,-989r-506,989r-63,0r-200,-1485r208,0r119,990r497,-990r70,0r147,985r460,-985r218,0","w":1745,"k":{"i":35,"e":132,"a":98,"A":176,".":197,"-":98,",":258}},"X":{"d":"818,0r-244,-565r-416,565r-232,0r565,-770r-271,-696r207,1r200,536r418,-536r231,0r-568,720r334,745r-224,0","w":1140},"Y":{"d":"714,-656r-116,656r-200,0r116,-656r-332,-809r209,0r249,625r461,-625r226,0","w":1168,"k":{"v":111,"u":163,"q":226,"p":165,"o":208,"i":63,"e":217,"a":213,"A":261,";":76,":":76,".":300,"-":230,",":300," ":37}},"Z":{"d":"80,0r0,-50r817,-1235r-620,0r31,-180r876,0r0,50r-789,1235r614,0r-32,180r-897,0","w":1127},"[":{"d":"22,420r340,-1930r473,0r-30,170r-263,0r-280,1590r263,0r-30,170r-473,0","w":752},"\\":{"d":"490,0r-305,-1471r142,0r306,1471r-143,0","w":728},"]":{"d":"466,420r-473,0r30,-170r263,0r280,-1590r-263,0r30,-170r473,0","w":752},"^":{"d":"906,-907r-244,-448r-248,452r-122,0r318,-568r107,0r316,564r-127,0"},"_":{"d":"-8,254r0,-129r1085,0r0,129r-1085,0"},"`":{"d":"661,-1225r-156,-333r197,0r59,333r-100,0"},"a":{"d":"397,20v-216,0,-335,-138,-335,-362v0,-196,58,-370,174,-522v116,-152,264,-227,446,-227v172,0,295,29,370,87r-131,623v-21,129,1,271,41,381r-194,0v-11,-21,-22,-57,-34,-108v-60,75,-201,128,-337,128xm842,-893v-18,-29,-79,-43,-182,-43v-105,0,-198,56,-278,168v-80,112,-120,252,-120,420v0,142,63,213,190,213v66,0,128,-35,186,-103v58,-68,98,-155,121,-262","w":1076},"b":{"d":"1088,-621v0,328,-274,641,-608,641v-109,0,-184,-41,-227,-123r-101,123r-125,0v43,-125,81,-269,110,-435r192,-1095r184,0r-89,552v50,-89,139,-133,267,-133v243,0,397,207,397,470xm474,-136v221,0,408,-255,408,-469v0,-217,-96,-326,-288,-326v-76,0,-142,49,-197,147r-100,521v14,60,97,127,177,127","w":1141},"c":{"d":"90,-395v0,-380,236,-699,596,-696v103,0,183,18,242,54r-35,163v-48,-38,-112,-57,-193,-57v-253,0,-411,241,-411,503v0,155,105,285,241,285v97,0,189,-30,278,-89r-21,194v-87,39,-183,58,-287,58v-258,0,-410,-163,-410,-415","w":942},"d":{"d":"82,-377v0,-386,233,-714,598,-712v101,0,179,42,233,126r101,-547r181,0r-261,1510r-188,0r23,-123v-77,95,-183,142,-317,142v-234,0,-370,-159,-370,-396xm697,-929v-251,0,-410,240,-410,511v0,189,78,283,233,283v169,0,285,-194,314,-371r44,-268v-19,-61,-90,-155,-181,-155","w":1141},"e":{"d":"1065,-829v3,247,-252,377,-511,377v-96,0,-177,-18,-243,-54v-43,215,63,366,272,366v79,0,158,-29,238,-87r-20,194v-107,35,-201,53,-283,53v-276,0,-414,-155,-414,-464v0,-351,263,-647,612,-647v194,0,348,81,349,262xm344,-644v184,74,533,35,533,-164v0,-82,-57,-123,-170,-123v-173,0,-294,96,-363,287","w":1100},"f":{"d":"899,-1332v-51,-19,-90,-28,-118,-28v-121,0,-198,96,-231,289r248,0r-16,131r-251,0r-169,1010v-29,189,-191,314,-387,338r-17,-117v80,-13,184,-137,199,-221r177,-1010r-151,0r22,-131r147,0v59,-293,206,-439,441,-439v56,0,103,10,142,30","w":822},"g":{"d":"877,31v0,379,-630,507,-890,269r90,-140v122,61,223,92,303,92v151,1,308,-53,308,-186v0,-135,-191,-113,-306,-143v-71,-19,-107,-54,-107,-109v0,-44,57,-88,171,-133v-183,19,-326,-130,-328,-297v-4,-275,205,-475,480,-475v101,0,180,24,238,72r90,-102r105,108r-99,103v19,27,29,70,29,129v2,235,-137,406,-315,467v-94,33,-140,64,-140,93v-2,58,82,26,121,26v167,0,250,75,250,226xm761,-762v0,-107,-70,-176,-177,-176v-152,0,-272,147,-272,300v0,145,55,218,165,218v149,0,284,-192,284,-342","w":1028},"h":{"d":"762,-1091v229,0,331,179,289,418r-119,673r-196,0r119,-673v28,-148,-26,-263,-173,-258v-103,3,-218,74,-269,135r-141,796r-194,0r261,-1510r189,0r-88,557v57,-72,197,-138,322,-138","w":1141},"i":{"d":"312,-1358v0,-72,61,-133,133,-133v72,0,133,61,133,133v0,71,-62,132,-133,132v-71,0,-133,-61,-133,-132xm138,0r162,-911r-142,0r35,-157r327,0r-189,1068r-193,0","w":628},"j":{"d":"448,-1358v0,-71,62,-133,133,-133v71,0,133,62,133,133v0,71,-62,132,-133,132v-71,0,-133,-61,-133,-132xm-139,415r8,-168v230,0,361,-84,393,-252r172,-906r-141,0r34,-160r329,0r-193,1055v-58,307,-238,429,-602,431","w":751},"k":{"d":"441,-473r-75,65r-70,408r-190,0r253,-1510r185,0r-137,878v251,-235,405,-393,463,-474r128,115v-107,119,-244,257,-409,414r404,577r-224,0","w":1033},"l":{"d":"489,-120r-22,140v-214,0,-321,-79,-321,-238v0,-48,17,-155,50,-321r192,-971r198,0r-183,912v-38,189,-57,308,-57,356v0,81,48,122,143,122","w":656},"m":{"d":"1015,-948v51,-77,199,-143,324,-143v231,0,322,149,282,375r-127,716r-195,0r120,-678v28,-144,-22,-258,-170,-253v-95,3,-196,72,-232,139r-140,792r-195,0r135,-761v17,-115,-48,-169,-186,-170v-86,1,-197,83,-233,141r-140,790r-194,0r138,-781v12,-76,6,-216,-14,-274r185,-35v12,51,19,98,21,140v48,-84,193,-142,325,-141v153,0,251,48,296,143","w":1700},"n":{"d":"728,0r112,-623v10,-55,15,-101,15,-138v0,-113,-59,-170,-177,-170v-102,1,-220,73,-269,135r-139,796r-192,0r144,-812v12,-78,2,-180,-16,-243r184,-36v18,97,27,150,26,159v81,-106,199,-159,352,-159v193,0,290,99,290,296v0,39,-4,83,-13,132r-115,663r-202,0","w":1119},"o":{"d":"472,20v-258,0,-399,-155,-399,-414v0,-359,245,-697,595,-697v259,0,402,147,401,405v0,103,-20,209,-61,320v-75,205,-264,386,-536,386xm641,-936v-253,0,-368,277,-368,530v0,181,76,271,227,271v113,0,202,-55,268,-164v66,-109,100,-236,100,-379v0,-172,-76,-258,-227,-258","w":1099},"p":{"d":"490,25v-69,0,-210,-35,-231,-79r-84,479r-190,0r210,-1176v18,-101,19,-201,-1,-299r191,-36v3,9,9,54,18,137v51,-68,188,-137,299,-137v266,0,396,131,399,397v4,382,-238,714,-611,714xm899,-663v-1,-177,-89,-262,-266,-263v-80,-1,-211,75,-243,125r-103,590v20,41,115,76,176,76v292,0,438,-222,436,-528","w":1141},"q":{"d":"79,-381v0,-375,254,-710,621,-710v95,0,176,34,243,101r51,-81r158,0v-41,133,-68,239,-82,318r-209,1173r-190,0r85,-483v-65,55,-162,83,-293,83v-216,0,-384,-189,-384,-401xm283,-427v0,179,98,288,274,287v91,0,166,-23,225,-70r113,-639v-45,-55,-108,-82,-191,-82v-254,0,-421,244,-421,504","w":1141},"r":{"d":"835,-883v-109,-81,-237,-55,-333,45v-60,63,-100,137,-115,224r-109,614r-190,0r189,-1071r190,0r-30,171v92,-127,206,-191,343,-191v23,0,60,5,109,14","w":853,"k":{".":269,"-":150,",":269}},"s":{"d":"753,-352v0,235,-200,372,-441,372v-113,0,-214,-28,-303,-84r99,-180v40,44,160,104,237,104v113,2,211,-67,205,-178v-5,-85,-60,-105,-136,-151v-115,-69,-269,-116,-271,-292v-3,-204,191,-330,401,-330v78,0,172,25,282,74r-85,176v-65,-60,-136,-90,-211,-90v-91,0,-189,53,-184,140v5,89,60,107,138,153v115,67,269,111,269,286","w":829},"t":{"d":"425,20v-177,0,-271,-149,-232,-333r128,-608r-124,0r32,-150r124,0r44,-224r217,-82r-71,306r294,0r-32,150r-294,0r-112,532v-36,136,-1,249,139,249v49,0,102,-12,159,-37r-7,167v-55,20,-143,30,-265,30","w":860},"u":{"d":"362,20v-207,0,-293,-171,-255,-388r124,-703r200,0r-125,683v-30,142,17,248,166,248v147,0,299,-138,324,-271r122,-660r200,0r-196,1071r-200,0r28,-151v-75,114,-204,171,-388,171","w":1140},"v":{"d":"460,20r-50,0r-311,-1094r198,0r192,737r407,-737r219,0","w":1003,"k":{".":250,",":250}},"w":{"d":"1042,20r-50,0r-199,-697r-428,697r-50,0r-200,-1094r193,0r117,681r399,-681r50,0r192,686r336,-686r197,0","w":1524,"k":{".":234,",":234}},"x":{"d":"701,0r-188,-376r-295,376r-232,0r441,-557r-270,-514r224,0r177,372r272,-372r250,0r-427,530r295,541r-247,0","w":1026},"y":{"d":"31,420r0,-191v235,0,320,-60,376,-224v-94,0,-156,-93,-187,-278r-134,-798r207,0r118,777v11,77,39,115,82,115r386,-892r216,0r-537,1199v-99,208,-216,291,-527,292","w":1010,"k":{".":239,",":239}},"z":{"d":"336,-170r533,0r-30,170r-831,0r0,-50r657,-851r-549,0r30,-170r836,0r0,54","w":972},"{":{"d":"394,-344v0,81,-145,361,-136,453v16,159,118,172,304,171r-24,140r-139,0v-178,2,-347,-82,-347,-249v0,-109,159,-421,159,-530v0,-101,-59,-156,-176,-164r15,-84v157,-9,255,-135,255,-304v0,-47,-18,-192,-18,-238v0,-220,214,-357,441,-353r148,0r-23,133r-175,0v-137,0,-202,109,-202,254v0,39,16,157,16,195v0,70,-21,133,-62,188v-41,55,-114,110,-219,165v122,54,183,128,183,223","w":752},"|":{"d":"462,276r0,-1681r146,0r0,1681r-146,0"},"}":{"d":"463,29v0,250,-198,395,-455,391r-139,0r24,-140v280,-2,379,-68,387,-317v1,-39,-12,-162,-12,-201v0,-149,92,-258,276,-329v-119,-77,-178,-159,-178,-246v0,-89,130,-331,130,-425v0,-87,-46,-131,-137,-131r-175,0r23,-133r148,0v169,-2,340,82,340,242v0,91,-150,380,-150,475v0,109,58,169,174,178r-15,84v-170,11,-255,115,-255,311v0,47,14,194,14,241","w":752},"~":{"d":"947,-735v-26,114,-116,238,-243,238v-63,0,-127,-19,-191,-59v-64,-40,-114,-60,-151,-60v-91,0,-155,27,-194,80r-40,-20v16,-113,124,-226,247,-226v75,0,147,22,213,66v66,44,110,67,132,67v103,-4,124,-27,178,-103"},"\u00a0":{"w":617,"k":{"Y":37,"A":76}}}});
